%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Suppose 
% @cels{1} = tmp1
% @cels{2} = tmp2
% @cels{3} = tmp3
%  where tmp1~3 are the structure having tmp1.a and tmp1.b
%
% If a is row-vector
%   return:   t_cell(cels, 'a') = [tmp1.a, tmp2.a, tmp3.a]
% column-vector
%   return:   t_cell(cels, 'a') = [tmp1.a; tmp2.a; tmp3.a]
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = t_cell(cels,fld,varargin)

if(length(varargin) == 0)
  t = size(cels); ln = length(t); %ln ͎
else
  error('# of input is should be 2.');
end

if(ln == 1)
  tmp1 = length(getfield(cels{1}, fld));
  if(tmp1 >= 1 & size(getfield(cels{1}, fld),2) == 1)
    ret = zeros(tmp1, t);
    for lp=1:t
      ret(:,lp) = getfield(cels{lp}, fld);
    end
  elseif(tmp1 >= 1 & size(getfield(cels{1}, fld),1) == 1)
    ret = zeros(t, tmp1);
    for lp=1:t
      ret(lp,:) = getfield(cels{lp}, fld);
    end
  else
    error('vector(incl. scalar) field is allowed.');
  end
  
elseif(ln == 2)
  if(isscalar(getfield(cels{1}, fld)) == 1)
    ret = zeros(t);
    for k1=1:t(1)
      for k2=1:t(2)
	ret(k1,k2) = getfield(cels{k1,k2}, fld);
      end
    end
  else
    error('indicated field must be scalar (if the cell has multi-dimensional)');
  end
end

