%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Given 
% x = [x1, x2,...,xN]
% xk= [xr(1), xi(1)]
%     [xr(2), xi(2)]
%       :      :
%     [xr(T), xi(T)]
%
% Return
% absolute value and angle of x 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [magv, theta] = sig_polar(x,varargin)

if(round(size(x,2)/2) - size(x,2)/2 ~= 0)
  error('number of columns must be even');
end

[T,N] = size(x); N = round(N/2);

theta = zeros(T,N);
magv = zeros(T,N);
for j=1:N
  theta(:,j)= sigang(x(:,2*j-1:2*j));
  magv(:,j) = sigabs(x(:,2*j-1:2*j));
end
