%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = gsig(t, psig)

switch psig.typ
  case 1
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % .typ = 1: power signal is modeled as trapezoidal as follows:
    % 
    % (active or reactive) power
    % ^         time, power(k=2)    time, power(k=3)
    % |         .-------------------.
    % |        /                     \.________________
    % |      ./                       time, power(k=4)
    % |     time(k=1)
    %       power(k=1)
    % -------------------------------------------------> time[s]
    % 
    % sample program is as follows;
    % Psig{1,1}.typ=1; 
    % Psig{1,1}.t = [0,3,15,18];
    % Psig{1,1}.p = [[0.1;0], [0.2;0], [0.2;0], [0.0;0]];
    % t=linspace(0,30,1000); P=zeros(1,1000);  
    % for k=1:1000
    % tmp = gsig(t(k),Psig{1,1}); P(k)=tmp(1);
    % end
    % plot(t,P)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    ti = max(find(psig.t - t <= 0));
    
    if(ti < length(psig.t))
      T = psig.t(ti:ti+1); % t is in the interval[.t(ti), .t(ti+1)]
      P = psig.p(:,ti:ti+1); % the corresponding signal
    
      %linear interpolation 
      ret = (P(:,2)-P(:,1))/(T(2) - T(1)) * (t - T(1)) + P(:,1); 
    
    else
      ret = psig.p(:,end); 
      
    end
    
end
