%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  (1) varargin is empty
%        Given:  cels = {A1,A2,A3}, 
%        ret = blkdiag(A1, A2, A3)
%
%  (2) varargin = cels2:
%       Given cels  = {A1,A2,A3}, cels2 = {B1,B2,B3}
%       ret = blkdiag(A1*B1, A2*B2, A3*B3)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = d_cell(cels,varargin)

if(length(varargin) == 0)
  t = length(cels);
elseif(length(varargin) == 1)
  cels2 = varargin{1};
  t = length(cels);
  if(t ~= length(cels2)); error('# of cells is incorrect.'); end
else
  error('# of input is less that 2.');
end
totn = 0; totm = 0;

for lp=1:t
  [tn,tm] = size(cels{lp});
  if(length(varargin) == 1)
    [tn2,tm] = size(cels2{lp});
  end
  totn = totn + tn;
  totm = totm + tm;
end

tmp = zeros(totn,totm);
totn = 0; totm = 0;
for lp=1:t
  [tn,tm] = size(cels{lp});
  if(length(varargin) == 1)
    [tn2,tm] = size(cels2{lp});
    tmp(totn+1:totn+tn, totm+1:totm+tm) = cels{lp}*cels2{lp};  
  else
    tmp(totn+1:totn+tn, totm+1:totm+tm) = cels{lp};  
  end
  totn = totn + tn;
  totm = totm + tm;
end
ret = tmp;