%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% convert "augmented real" matrix (or vector) from "complex" one, vice cersa
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = comp2augreal(Y,type,varargin)


if(length(varargin) == 0)
    
  if strcmp(type,'mat')
    %initialize
    ret = zeros(2*size(Y)); 

    % generate "augmented real" matrix from complex matrix
    for row=1:size(Y,1)
      for col=1:size(Y,2)
	yreal = real(Y(row,col));
	yimag = imag(Y(row,col));
	ret(2*row-1:2*row, 2*col-1:2*col) = [yreal, -yimag; yimag, yreal];
      end
    end
    
  elseif strcmp(type,'vec')    
    if(size(Y,2) > 1); error('input Y must be vector if type is vec'); end
    
    n = length(Y);
    ret = reshape(vec2mat([real(Y); imag(Y)],n),[2*n,1]); 
    end
  
elseif(length(varargin) == 1 && strcmp(varargin{1}, 'inv') == 1)
  
  %initialize
  n = size(Y,1)/2;
  if(norm(n-round(n)) > 1e-4); error('# of rows of input must be of length 2*n'); end
  n = round(n);

  
  if strcmp(type,'mat')

    %initialize(cont'd)
    m = size(Y,2)/2;
    if(norm(m-round(m)) > 1e-4); error('# of columns of input must be of length 2*n'); end
    m = round(m);  
    
    ret = zeros(n,m); 
  
    % generate complex matrix from "augmented real" matrix
    for row=1:n
      for col=1:m
	ext = Y(2*row-1:2*row,2*col-1:2*col); 
	
	if(norm(ext(1,1) - ext(2,2)) > 1e-8 || norm(-ext(1,2) - ext(2,1)) > 1e-8)
	  error('input matrix is not augmented real'); 
	end
	  
	ret(row, col) = ext(1,1) + i*ext(2,1); 
      end
    end
    
  elseif strcmp(type,'vec')
    if(size(Y,2) > 1); error('input Y must be vector if type is vec'); end
    ret = Y([1:2:end]) + sqrt(-1)*Y([2:2:end]); 
  end

end
