%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% multiplication of x for y, where x and y are "augmented real" vector
% remark: vec must be of length 2*n
%
% return   x*y
% if varargin{1} == inv
% return   y/x
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = comp2augreal_prod(x,y,varargin)

n = length(x)/2;
if(norm(n-round(n)) > 1e-4); error('input must be of length 2*n'); end
n = round(n);
if(norm(2*n - length(y)) > 1e-4); error('length of x must be that of y'); end

xaug = zeros(2*n, 2*n);

if(length(varargin) == 0)

  for i=1:n
    xreal = x(2*i-1);
    ximag = x(2*i);
    
    xaug(2*i-1:2*i, 2*i-1:2*i) = [xreal, -ximag; ximag, xreal];
  end
  
  ret = xaug*y;

elseif(length(varargin) == 1 && strcmp(varargin{1},'inv'))

  for i=1:n
    xreal = x(2*i-1);
    ximag = x(2*i);
    
    xinv(2*i-1:2*i, 2*i-1:2*i) = inv([xreal, -ximag; ximag, xreal]);
  end
  
  ret = xinv*y;
  
end

