%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% make augmented indices associated with
%   "real" augmented matrix generated by "complex" one
% ex: give   indices = [1;2;5;7]
%     return [1;2;3;4;9;10;13;14] 
%
% if varargin == "inv", return contracted indices
% ex: give   [1;2;3;4;9;10;13;14] 
%     return [1;2;5;7]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = comp2augreal_ind(indices,varargin)

if(length(varargin) == 0)
  ret = zeros(2*length(indices),1); 
  for row=1:length(indices)
    ret([2*row-1,2*row]) = [2*indices(row)-1; 2*indices(row)];
  end

else
  if(strcmp(varargin{1},'inv') == 1)
    
    n = length(indices)/2;
    if(norm(n-round(n)) > 1e-4); error('input must be of length 2*n'); end
    n = round(n);
    
    ret = zeros(n,1); 
    for row=1:n
      ret(row) = indices(2*row)/2;
    end
    
    if(norm(ret-round(ret)) > 1e-4); error('inverse calculation was failed'); end
  end
end