%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% extract "imaginary" part of "augmented real" vector
% ex: give    vec = [a;aj; b; bj];
%     return        [aj;bj]
% remark: vec must be of length 2*n and column vector
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = augreal_imag(vec)

n = length(vec)/2;

if(norm(n-round(n)) > 1e-4); error('input must be of length 2*n'); end

n = round(n);

ret = EYE(2*n,[2:2:2*n])'*vec;

