%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% taking conjugate vector for "augmented real" vector
% ex: give    vec = [1;-1;2; 2;3;-3]
%     return        [1; 1;2;-2;3; 3]
% remark: vec must be of length 2*n
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = comp2augreal_conj(vec)

n = length(vec)/2;

if(norm(n-round(n)) > 1e-4); error('input must be of length 2*n'); end

n = round(n);

ret = kron(eye(n),[1,0;0,-1])*vec;

