%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% extract "imaginary" part of "augmented real" vector
% ex: give    vec = [a;aj; b; bj];
%     return        [||[a aj]|| ; ||[b bj]||]
% remark: vec must be of length 2*n and column vector
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = augreal_angle(vec)

n = length(vec)/2;

if(norm(n-round(n)) > 1e-4); error('input must be of length 2*n'); end

n = round(n);
ret = zeros(n,1);

for k=1:n
  v = vec(2*k-1:2*k);
  ret(k) = angle(v(1)+sqrt(-1)*v(2));
end


