%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Simulation: with single retrofit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1
  fprintf(' ======== with retrofit =========\n');
  flag = 1*ones(1,NW); %with compensator
  flag_pv = -1*ones(1,NP); %with compensator
  flag_g = -1; %without use global controller
  ff = 0;
  %x0_dae = [init_x;init_w(net.nw+1:end)]; %equilibrium
  x0_dae = [init_x;init_w(1:net.nw)]; %equilibrium
  n_add = n_dae(flag, flag_pv); 
  n_ode = n + n_add; 
  Mw4 = blkdiag(eye(net.n), zeros(net.nDAE), eye(n_add));
  options = odeset('Mass',Mw4,'RelTol', tol,'AbsTol', tol); 

  % ****** solving dae*******
  [twg_s, xwg_s] = ode15s(@psm_15s,[0:0.01:sims.te], [init_x+ds;init_w(1:net.nw)], options);sims.odemem = 0;
  % add pre fault trajectories for journal
  [twg_s,xwg_s] = add_prefault_traj(twg_s,xwg_s,-1, x0_dae); 
  
  % calculate some physical quantities
  t = twg_s; x = xwg_s; 
  cal_sg; if(NW>0); cal_wind; end; if(NP>0); cal_pv; end; 

  res_sr.t = twg_s;
  res_sr.ome = ome;
  res_sr.thdiff = thdiff;
  if NP>0
    res_sr.ig_pv = ig_pv; 
    res_sr.vdc_pv = vdc_pv; 
    res_sr.mG = mGpv;
    res_sr.PP = PP;
  end
  if NW>0
    res_sr.wl = wl;
    res_sr.wr = wr;
    res_sr.thT = thT;
    res_sr.is = is;
    res_sr.ir = ir;
    res_sr.P = PW;
    res_sr.uw = us;    
    res_sr.ig = ig;
    res_sr.vdc = vdc;
    res_sr.mG = mG;
    if sto_flag==1
      res_sr.vb = vb;
    end
  end
end
