%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Simulation: with all retrofit + global
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1
  fprintf(' ======== with retrofit + global =========\n');
  flag = 1*ones(1,NW); %with compensator
  flag_pv = 1*ones(1,NP); %with compensator
  flag_g = 1; %with use global controller
  ff = 0;
  x0_dae = [init_x;init_w;gl.x0]; %equilibrium
  n_add = n_dae(1*ones(1,NW), 1*ones(1,NP)); 
  n_ode = n + n_add + gl.n; 
  Mw3 = blkdiag(eye(net.n), zeros(net.nDAE), eye(n_add+gl.n));
  options = odeset('Mass',Mw3,'RelTol', tol,'AbsTol', tol); 

  % ****** solving dae*******
  [twg, xwg] = ode15s(@psm_15s,[0:0.01:sims.te], [init_x+ds;init_w;gl.x0], options);sims.odemem = 0;
  % add pre fault trajectories for journal
  [twg,xwg] = add_prefault_traj(twg,xwg,-1, x0_dae); 
  
  % calculate some physical quantities
  t = twg; x = xwg; 
  cal_sg; if(NW>0); cal_wind; end; if(NP>0); cal_pv; end; 

  res_gl.t = twg;
  res_gl.ome = ome;
  res_gl.thdiff = thdiff;
  if NP>0
    res_gl.ig_pv = ig_pv; 
    res_gl.vdc_pv = vdc_pv; 
    res_gl.mG = mGpv;
    res_gl.PP = PP;
  end
  if NW>0
    res_gl.wl = wl;
    res_gl.wr = wr;
    res_gl.thT = thT;
    res_gl.is = is;
    res_gl.ir = ir;
    res_gl.P = PW;
    res_gl.ig = ig;
    res_gl.vdc = vdc;
    res_gl.mG = mG;
  end
end
