%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Simulation: with all retrofit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for lp=1:length(gain_i)
  fprintf('\n =========== with retrofit ===============\n');
  flag = 1*ones(1,NW); %with compensator
  flag_pv = 1*ones(1,NP); %with compensator
  flag_g = -1; %without use global controller
  ff = 0;
  x0_dae = [init_x;init_w]; %equilibrium
  n_ode = n + n_dae(flag, flag_pv); 
  Mw2 = blkdiag(eye(net.n), zeros(net.nDAE), eye(n_dae(flag, flag_pv)));
  options = odeset('Mass',Mw2,'RelTol', tol,'AbsTol', tol); 
  
  % ****** solving dae*******
  [tw{lp}, xw{lp}] = ode15s(@psm_15s,[0:0.01:sims.te], [init_x+ds;init_w], options);sims.odemem = 0;

  % add pre fault trajectories for journal
  [tw{lp},xw{lp}] = add_prefault_traj(tw{lp},xw{lp},-1, [init_x;init_w]); 
  
  % calculate some physical quantities
  t = tw{lp}; x = xw{lp}; 
  cal_sg; if(NW>0); cal_wind; end; if(NP>0); cal_pv; end; 

  res{lp}.t = tw{lp};
  res{lp}.ome = ome;
  res{lp}.thdiff = thdiff;
  res{lp}.vW = vabs_G; 
  res{lp}.vG = vabs_G; 
  if NP>0
    res{lp}.ig_pv = ig_pv; 
    res{lp}.vdc_pv = vdc_pv; 
    res{lp}.mG = mGpv;
    res{lp}.PP = PP;
    res{lp}.upv = upv;    
  end
  if NW>0
    res{lp}.wl = wl;
    res{lp}.wr = wr;
    res{lp}.thT = thT;
    res{lp}.is = is;
    res{lp}.ir = ir;
    res{lp}.P = PW;
    res{lp}.uw = us;    
    res{lp}.ig = ig;
    res{lp}.vdc = vdc;
    res{lp}.mG = mG;
    if sto_flag==1
      res{lp}.vb = vb;
    end
  end
end
