%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Simulation: with global only
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1
  fprintf(' ======== with global only =========\n');
  flag = -1*ones(1,NW); %with compensator
  flag_pv = -1*ones(1,NP); %with compensator
  flag_g = 1; %with use global controller
  ff = 0;
  x0_dae = [init_x;gl.x0]; %equilibrium
  n_ode = n + gl.n; 
  Mw5 = blkdiag(eye(net.n), zeros(net.nDAE), eye(gl.n));
  options = odeset('Mass',Mw5,'RelTol', tol,'AbsTol', tol); 

  % ****** solving dae*******
  glsi_tmp = gl.si; 
  gl.si = [n+1:n+gl.n]; %rewrite
  [twgo, xwgo] = ode15s(@psm_15s,[0:0.01:sims.te], [init_x+ds;gl.x0], options);sims.odemem = 0;
  % add pre fault trajectories for journal
  [twgo,xwgo] = add_prefault_traj(twgo,xwgo,-1, x0_dae); 
  
  % calculate some physical quantities
  t = twgo; x = xwgo; 
  cal_sg; if(NW>0); cal_wind; end; if(NP>0); cal_pv; end; 
  
  %recover
  gl.si = glsi_tmp; 

  res_glo.t = twgo;
  res_glo.ome = ome;
  res_glo.thdiff = thdiff;
  if NP>0
    res_glo.ig_pv = ig_pv; 
    res_glo.vdc_pv = vdc_pv; 
    res_glo.mG = mGpv;
    res_glo.PP = PP;
  end
  if NW>0
    res_glo.wl = wl;
    res_glo.wr = wr;
    res_glo.thT = thT;
    res_glo.is = is;
    res_glo.ir = ir;
    res_glo.P = PW;
    res_glo.ig = ig;
    res_glo.vdc = vdc;
    res_glo.mG = mG;
  end
end
