%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% describe DAE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function dx = psm_15s(t,x)
global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk Yf n_ode ff Ykc init_EW
global net_f fcase Yf Yf_wof 
global ir_s ws vdc_s Q_s wr_s
global P_spv Q_spv ipv_s mG_s pv flag_pv Spv_s
global compw_pv
global flag_g addPSSu gl sys

% ***** initialization *****
dx = zeros(n_ode,1); 

EG = x(net.EGi);
EL = x(net.ELi);
EW = x(net.EWi);
EP = x(net.EPi);

IG = zeros(2*NG,1); 
IL = zeros(2*NL,1); 
IW = zeros(2*NW,1); 
IP = zeros(2*NP,1); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Sync. generators
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% **** If global controller is used ****
if flag_g == 1
  uG = gl.F*x(gl.si); 
  dx(gl.si) = gl.K*x(gl.si) + gl.H*sys.C*x(1:net.ng); 
end

% **** Sync. generators ****
for j=1:NG
  xgen = x(gpar{j}.si); 
  vg = EG(2*j-1) + sqrt(-1)*EG(2*j); 
  
  if flag_g == -1
    % without use Global controller
    u = 0;
  elseif flag_g == 0
    % for linearization only
    u = addPSSu(j);
  elseif flag_g == 1
    % with Global controller
    u = uG(j); 
  end
  
  % Differential equations
  dx(gpar{j}.si) = dae{j}.dxk(xgen, pm(j), abs(vg), angle(vg), Vref(j), vfdstar(j), u); 

  % Generated current
  IG(2*j-1:2*j) = dae{j}.cur(xgen, abs(vg), angle(vg));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Wind power plants with controller
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:NW
  xwin = x(win{j}.si); 
  vgrid = EW(2*j-1:2*j);
  
  % ================================
  % retrofit controller
  % ================================
  if flag(j) == -1
    % ****** without retrofit  *******
    u = zeros(win{j}.m,1);

  elseif flag(j) == 1
    % ****** controller with compensator  *******
    xhat = x(compw{j}.si); 
    
    dx(compw{j}.si) = compw{j}.f(xhat, xwin, vgrid);
    u = compw{j}.u(xhat, xwin);
  end
  
  % ================================
  % Wind speed 
  % ================================
  if(ws{j,1}.typ == 1)
    %sinusoidal (Note: includes constant speed case)
    windspeed = ws{j,1}.bias + ws{j,1}.fl*sin(ws{j,1}.w*t); 
  elseif(ws{j,1}.typ == 2)
    %trapezoidal
  end

  % ================================
  % Dynamics
  % ================================
  dx(win{j}.si) = win{j}.f(xwin, vgrid, wr_s{j}, ir_s{j}, vdc_s{j}, Q_s{j}, init_EW(2*j-1:2*j), windspeed, u);

  IW(2*j-1:2*j) = win{j}.cur(xwin);
  PW(2*j-1:2*j) = win{j}.pow(vgrid, xwin) + delPW; %delPW is used for linearization only
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if(mpc.load == 1) %constant power
  IL= augreal_conj(augreal_prod(EL, init_PL, 'inv'));
elseif(mpc.load == 2) %constant impedance
  IL = -YL*EL; 
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solar 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:NP
  xPV = x(pv{j}.si); 
  vgrid = EP(2*j-1:2*j);
  
  % ================================
  % retrofit controller
  % ================================
  if flag_pv(j) == -1
    % ****** without retrofit  *******
    u = zeros(pv{j}.m,1);
    
  elseif flag_pv(j) == 1
    % ****** controller with compensator  *******
    xhat = x(compw_pv{j}.si); 
    
    dx(compw_pv{j}.si) = compw_pv{j}.f(xhat, xPV, vgrid);
    u = compw_pv{j}.u(xhat, xPV);
  end
  
  dx(pv{j}.si) = pv{j}.f(xPV, vgrid, P_spv{j}, Q_spv{j}, Spv_s{j}, u);  
  IP(2*j-1:2*j) = pv{j}.cur(xPV);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% algebraic constraint   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
I = [IG; IL; IW; IP]; 
E = [EG; EL; EW; EP]; 

if(ff == 0) % health
  dx([net.EGi, net.ELi, net.EWi, net.EPi]) = I -  Yk*E;

elseif(ff == 1) % fault happned
  if fcase 
    % Case 1) fault happens at gen, load, wind, or PV bus      
    dx([net.EGi, net.ELi, net.EWi, net.EPi]) = I -  Yk*E;
    dx(net_f.EFi) = x(net_f.EFi);
  else
    % Case 0) fault happens at the other bus
    dx([net.EGi, net.ELi, net.EWi, net.EPi]) = I - Yf_wof*E; 
    dx(net_f.EFi) = x(net_f.EFi);
  end
end

%show progress
if(t>(sims.te/sims.odeprg)*sims.odemem)
  fprintf('*'); sims.odemem = sims.odemem + 1; 
  if(sims.odeprgx); fprintf('(%2.0f%%) norm=%.1f\n',100*sims.odemem/sims.odeprg, norm(x-x0_dae)); end
end