%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot for article (no controllers / single retrofit)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
col = [0 0 1; 1 0 0; 0 0.8 0; 1 1 0; 0.5 0.5 0.1]; 
figure;

% ***********************************
% Rotor angular speed (Hz)
% ***********************************
subplot(2,3,1);
plot(res_ori.t, res_ori.wr,'r-','linewidth',1); hold on; 
plot(res_sr.t, res_sr.wr,'b-','linewidth',1); hold on; 
plot([res_sr.t(1) res_sr.t(end)], (1/(2*pi))*(omega0/2)*wr_s{j}*[1,1],'k--','linewidth',1);
grid on; ylabel('wr[Hz]'); xlim([res_sr.t(1) res_sr.t(end)]); 

  
% ***********************************
% DFIG current (pu)
% ***********************************
subplot(2,3,2);
plot(res_ori.t, res_ori.is(:,1),'r-','linewidth',1); hold on; 
plot(res_ori.t, res_ori.is(:,2),'r--','linewidth',1); 
plot(res_sr.t, res_sr.is(:,1),'b-','linewidth',1); hold on; 
plot(res_sr.t, res_sr.is(:,2),'b--','linewidth',1); 
grid on; ylabel('DFIG current[pu]'); xlim([res_sr.t(1) res_sr.t(end)]); 
legend('ids', 'iqs'); 

% ***********************************
% Active and Reactive power to grid (MW)
% ***********************************
subplot(2,3,3);
plot(res_ori.t, mpc.baseMVA*real(res_ori.P(:, j)),'r-','linewidth',1); hold on; 
plot(res_ori.t, mpc.baseMVA*imag(res_ori.P(:, j)),'r--','linewidth',1); hold on; 
plot(res_sr.t, mpc.baseMVA*real(res_sr.P(:, j)),'b-','linewidth',1); hold on; 
plot(res_sr.t, mpc.baseMVA*imag(res_sr.P(:, j)),'b--','linewidth',1); hold on; 
plot([res_sr.t(1) res_sr.t(end)], mpc.baseMVA*init_PW(1)*[1,1],'k--','linewidth',1);
plot([res_sr.t(1) res_sr.t(end)], mpc.baseMVA*init_PW(2)*[1,1],'k--','linewidth',1);
grid on; ylabel('Output power(MW)'); xlim([res_sr.t(1) res_sr.t(end)]);
legend('P', 'Q'); 
  
% ***********************************
% Duty Cycle 
% ***********************************  
subplot(2,3,4);
plot(res_ori.t, res_ori.mG{1}(:, 1),'r-','linewidth',1); hold on; 
plot(res_ori.t, res_ori.mG{1}(:, 2),'r--','linewidth',1);
plot(res_sr.t, res_sr.mG{1}(:, 1),'b-','linewidth',1); hold on; 
plot(res_sr.t, res_sr.mG{1}(:, 2),'b--','linewidth',1);
grid on; ylabel('Duty cycles'); xlim([res_sr.t(1) res_sr.t(end)]);  legend('mdG', 'mqG'); 

% ***********************************
% Frequency difference [Hz]
% ***********************************
subplot(2,3,5);
plot(res_ori.t, res_ori.ome,'r-','linewidth',1); hold on; 
plot(res_sr.t, res_sr.ome,'b-','linewidth',1); hold on; 
grid on; ylabel('ome[Hz]'); xlim([res_sr.t(1) res_sr.t(end)]); 

if sto_flag == 1
  subplot(2,3,6);
  plot(res_ori.t, res_ori.vb,'r-','linewidth',1); hold on; 
  plot(res_sr.t, res_sr.vb,'b-','linewidth',1); hold on; 
  grid on; ylabel('vb(V)'); xlim([res_sr.t(1) res_sr.t(end)]); 
end
