%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This funtion is used to do "Power Flow Calculation"
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% construct bus-admittance matrix and indices of geneators, etc. 
Ybus = y_sparse(mpc.bus, mpc.branch);

%# of nodes
bus.N = size(mpc.bus,1);

%indices of ...
if(norm(gamma)>0)
  bus.nW = mpc.added_wind; %Winds
else
  bus.nW = [];
end
if size(mpc.PVdata,2)>0
  bus.nP = mpc.added_PV;  %PV
else
  bus.nP = [];
end
tmp = sort([find(mpc.bus(:,10) == 2); find(mpc.bus(:,10) == 1)]); %generators & wind
bus.nG = setxor(tmp, bus.nW)'; %generators
bus.nL = intersect(find(mpc.bus(:,10) == 3), find(mpc.bus(:,6) ~= 0))'; %loads
bus.nN = setxor([1:bus.N], [bus.nG,bus.nL,bus.nW,bus.nP])'; %buses where nothing are connected

%indices of generators excepting base generator
bus.nGw= bus.nG;
bus.nGw(find(mpc.bus(:,10) == 1)) = [];

%base generator
bus.bG = setxor(bus.nG, bus.nGw); 

%index of base generator
net.bG = find(mpc.bus(:,10) == 1); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% power flow calculation
% See "note" to refer the detail of this part
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% convert "augmented real" ones
Ybus = comp2augreal(Ybus,'mat'); %overwrite
bus.nG = augreal_ind(bus.nG);
bus.nL = augreal_ind(bus.nL);
bus.nW = augreal_ind(bus.nW);
bus.nP = augreal_ind(bus.nP);
bus.nN = augreal_ind(bus.nN);
bus.nGw= augreal_ind(bus.nGw);
bus.bG = augreal_ind(bus.bG);
bus.N = 2*bus.N; 


% *****  solving nonlinear equation to calculate power flow *****
% give initial value 
%x0r = ones(round(bus.N/2),1)+0.0*rand(round(bus.N/2),1); 
x0 = mpc.bus(:,2) .* exp(i*pi*mpc.bus(:,3)/180);
x0 = comp2augreal(x0, 'vec');  

%V : "augmented real" voltage at buses [pu]
options = optimset('MaxFunEvals', 1e4);
[V,fval,exitflag,output] = fsolve(@(x) func_pf(x,mpc,bus,Ybus),x0,options);

%P : calculated "augmented real" power
%P = [p1;q1;p2;q2;...pN;qN] where pi(and qi) is active (and reactive) power at i-th bus
I = Ybus*V;
ic = augreal_conj(I);
P = augreal_prod(augreal_conj(I), V);

% ***** display *****
vc = comp2augreal(V,'vec','inv');
ic =  comp2augreal(I,'vec','inv');
pc = comp2augreal(P,'vec','inv');
[[1:bus.N/2]', abs(vc), angle(vc)*180/pi, real(pc), imag(pc)]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% node-admittance matrix
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
NG = round(length(bus.nG)/2); % # of generators
NL = round(length(bus.nL)/2); % # of loads
NW = round(length(bus.nW)/2); % # of winds
NP = round(length(bus.nP)/2); % # of solars
NN = round(length(bus.nN)/2); % # of nothing

nod.G = [1:2*NG]; 
nod.L = [2*NG+1 : 2*NG+2*NL]; 
nod.W = [2*NG+2*NL+1 : 2*NG+2*NL+2*NW]; 
nod.P = [2*NG+2*NL+2*NW+1 : 2*NG+2*NL+2*NW+2*NP]; 

%permutation matrix 
E = [EYE(bus.N, bus.nG)'; EYE(bus.N, bus.nL)'; EYE(bus.N, bus.nW)'; EYE(bus.N, bus.nP)'; EYE(bus.N, bus.nN)']; 

%permutated ...
Y = E*Ybus*E'; %"augmented real" bus-admittance matrix
V = E*V; %permutated "augmented real" voltage at buses [pu]

%Schur complement
node = [1:length(nod.G)+length(nod.L)+length(nod.W)+length(nod.P)]; 
nbus = setxor([1:bus.N]', node); %buses connecting to no nodes

Ynn = Y(node, node);
Ynb = Y(node, nbus);
Ybn = Y(nbus, node);
Ybb = Y(nbus, nbus);

%check: Kirchhoff's law
if(norm([Ybn, Ybb]*V) > 1e-7)
  error('must satisfy Kirchhoff law at buses which connect to nothing');
end

%"augmented real" node-admittance matrix
Yk = Ynn - Ynb*inv(Ybb)*Ybn; 
Ykc = comp2augreal(Yk, 'mat','inv'); 

%"augmented real" something at nodes
init_E = [V(nod.G); V(nod.L); V(nod.W); V(nod.P)]; %voltage at nodes [pu]
init_I = Yk * init_E; %current at nodes [pu]
init_P = augreal_prod(augreal_conj(init_I), init_E); %permutated "augmented real" power at buses [pu]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "augmented real" admittance of loads based on calcurated power flow [pu]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
il = init_I(nod.L); %constant current

% ***** identifying "augmented real" admittance of loads ****
yl = -comp2augreal(init_I(nod.L), 'vec', 'inv') ./ comp2augreal(init_E(nod.L), 'vec', 'inv'); %complex
YL = zeros(2*length(yl), 2*length(yl)); 
for lp=1:length(yl)
  YL(2*lp-1:2*lp, 2*lp-1:2*lp) = [real(yl(lp)), -imag(yl(lp)); imag(yl(lp)), real(yl(lp))];
end

%"augmented real" (generator,wind,PV)-admittance matrix
Ygwp = Yk([nod.G,nod.W,nod.P], [nod.G,nod.W,nod.P]) - Yk([nod.G,nod.W,nod.P], nod.L)*inv(YL + Yk(nod.L,nod.L))*Yk(nod.L,[nod.G,nod.W,nod.P]);

%"augmented real" (generator,wind)-admittance matrix (if PV = constant current)
nodG = [1:2*NG];
nodW = [2*NG+1:2*(NG+NW)];
nodP = [2*(NG+NW)+1:2*(NG+NW+NP)];
Ygw = Ygwp([nodG,nodW], [nodG,nodW]) - Ygwp([nodG,nodW], nodP)*inv(Ygwp(nodP,nodP))*Ygwp(nodP,[nodG,nodW]);
Ygw_i = Ygwp([nodG,nodW], nodP)*inv(Ygwp(nodP,nodP));

%"augmented real" generator-admittance matrix (if PV = constant current)
Yg = Ygw(nodG,nodG) - Ygw(nodG, nodW)*inv(Ygw(nodW,nodW))*Ygw(nodW,nodG);
Yg_iw = Ygw(nodG, nodW)*inv(Ygw(nodW,nodW));
Yg_ipv = Ygw_i(nodG,:) - Ygw(nodG, nodW)*Ygw_i(nodW,:); 
