%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Eigenvalue variation by changing Wind penetration level
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all; pause(0.1); addpath('./tool/');
global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk n_ode ff Ykc init_EW 
global net_f fcase Yf Yf_wof init_x
global ir_s is_s ws vdc_s Q_s
global Yg Yg_iw Yg_ipv wr_s
global P_spv Q_spv ipv_s mG_s pv flag_pv Spv_s
global compw_pv
global flag_g addPSSu gl sys

%% penetration levels of solar
gs = linspace(20, 100, 20); 
gpl = findsimilar(gs, [20, 60, 100], 'i');
res = cell(1, length(gs));
sims.type = 1;

% Flag for transient somulation
fTran = 0; 

for lops=1:length(gs)
  % **** Initial Settings ****
  % penetration of wind (connected bus#, reactance, P[MW])
  data_wind01;
  % penetration level of wind farm
  gamma = [gs(lops)]; 
  wind_con(1,2) = 22; %22
  
  % penetration of solar
  gamma_pv = 0; %pv farm
  data_pv01;
  
  % penetration level of storage
  mu = [0]; 

  % fault bus
  sims.fbus = 69;
  
  fprintf(' ********** Gam(Wind) = %.1f ***********\n', gs(lops)); 
  
  % Select a power network to be simulated
  data_68bus;
  
  % Power flow calculation
  pflow;
  % Pre-calculation
  precalc;
  % Initial settings
  init_state; 
  % error check
  flag = -1*ones(1,NW); %-1: use traditional controller
  flag_pv = -1*ones(1,NP); %-1: use traditional controller
  flag_g = -1; %without use global controller
  delPW = [0;0]; 
  ff = 0; %0: power line fault flag off
  n_ode = n; %dimension of whole system
  dx = psm_15s(0, init_x);
  if(norm(dx) > 1e-5); error('failed determining initial state'); end
  
  % Linearization 
  linearization_all;

  j=1;
  linearization;
  [v,e] = eig(lin{j}.A); 
  res{lops}.vw = v; 
  res{lops}.ew = diag(e); 
  [tmp, res{lops}.bw_w] = sigma(ss(lin{j}.A, lin{j}.R, lin{j}.Pow, [])); 
  res{lops}.bw_m = 20*log10(tmp);

  % Save data
  [v,e] = eig(sys.A); 
  res{lops}.v = v; 
  res{lops}.e = diag(e); 
  res{lops}.flag = isstable(sys.A); 
  res{lops}.gam = gs(lops);
  res{lops}.x0 = xw{1}; 
  
  % exit at final loop 
  if(lops == length(gs)); break; end

  % Clear
  clearvars -except res gs lops gpl fTran sims
  global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
  global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk n_ode ff Ykc init_EW 
  global net_f fcase Yf Yf_wof init_x
  global ir_s is_s ws vdc_s Q_s
  global Yg Yg_iw Yg_ipv wr_s
  global P_spv Q_spv ipv_s mG_s pv flag_pv
  
end
save('mot_wind.mat','res','gs','lops','gpl','fTran','sims');

% ===== Plot eigenvalue variation =====
figure; hold on; 
for lp = 1:length(gs)
  e = res{lp}.e;
  if(lp==gpl(1))
    plot(real(e), imag(e), 'o','Color', [0 0 1], 'MarkerSize', 10, 'linewidth',2); 
  elseif(lp==gpl(2))
    plot(real(e), imag(e), '^','Color', [0 0.9 0], 'MarkerSize', 10, 'linewidth',2); 
  elseif(lp==gpl(3))
    plot(real(e), imag(e), 's','Color',[1 0 0], 'MarkerSize', 10, 'linewidth',2); 
  else
    plot(real(e), imag(e), 'kx', 'MarkerSize', 10, 'linewidth',1); 
  end
end
grid on; xlim([-0.15 0.02]); ylim([-2.5 2.5]); 


% ===== Sigma plot of wind =====
if 1
  figure; 
  semilogx(1/(2*pi)*res{1}.bw_w, res{1}.bw_m, 'b-');hold on; 
  for lp = 2:2:length(gs)-1
    semilogx(1/(2*pi)*res{lp}.bw_w, res{lp}.bw_m, 'k-');
  end
  semilogx(1/(2*pi)*res{end}.bw_w, res{end}.bw_m, 'r-'); grid on; xlabel('freq (Hz)'); ylabel('gain(dB)');
  xlim([0.1 1]); ylim([-10 60]);
end

