%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Eigenvalue variation by changing Solar penetration level
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all; pause(0.1); addpath('./tool/');
global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk n_ode ff Ykc init_EW 
global net_f fcase Yf Yf_wof init_x
global ir_s is_s ws vdc_s Q_s
global Yg Yg_iw Yg_ipv wr_s
global P_spv Q_spv ipv_s mG_s pv flag_pv Spv_s
global flag_g addPSSu gl sys

%% penetration levels of solar
gs = linspace(20, 360, 20); 
gpl = findsimilar(gs, [20, 180, 300], 'i');
res = cell(1, length(gs));
traj = cell(1, length(gs));
sims.type = 1;

% Flag for transient somulation
fTran = 2; 

for lops=1:length(gs)
  % **** Initial Settings ****
  gamma = [0]; % penetration level of wind farm
  gamma_pv = gs(lops); %pv farm
  mu = [0]; % penetration level of storage
  
  sims.fbus = 22;

  fprintf(' ********** Gam(PV) = %.1f ***********\n', gs(lops)); 
  
  % Select a power network to be simulated
  data_wind01; 
  data_pv01;
  
  mpc.PVdata(1) = 22; 
  
  data_68bus;
  
  % Power flow calculation
  pflow;
  % Pre-calculation
  precalc;
  % Initial settings
  init_state; 
  % error check
  flag = -1*ones(1,NW); %-1: use traditional controller
  flag_pv = -1*ones(1,NP); %-1: use traditional controller
  flag_g = -1; %without use global controller
  delPW = [0;0]; 
  ff = 0; %0: power line fault flag off
  n_ode = n; %dimension of whole system
  dx = psm_15s(0, init_x);
  if(norm(dx) > 1e-5); error('failed determining initial state'); end
  
  % Linearization 
  linearization_all;

  % ======== fault simulation if you want ========
  if fTran~=0 & ismatch(gpl,lops)
    if(fTran == 2)
      ds = zeros(n,1);
      for j=1:NP
	ds(pv{j}.si(1:2)) = -0.7*init_x(pv{j}.si(1:2)); 
      end
      tf = []; xf = [];
     elseif(fTran == 1)
      ds = zeros(n,1); 
      fprintf('[ Fault Simulation (Bus = %d)]\n', sims.fbus);
      make_fault_settings; % do settings
          
      % ** determine initial disturbance **
      n_ode = n; 
      flag = -1*ones(1,NW); %traditional controller
      flag_pv = -1*ones(1,NP); %-1: use traditional controller
      flag_g = -1; %without use global controller
      x0_dae = init_x; %equilibrium
      ff = 1; %fault flag on
      options = odeset('Mass',Mf,'RelTol',1e-8,'AbsTol',1e-8);
      [tf,xf] = ode15s(@psm_15s,[-sims.ft:0.001:0], init_xf, options);sims.odemem = 0;
      ds = xf(end, 1:n)'-init_x(1:n); 
      tf = tf(1:end-1); xf = xf(1:end-1, :); 
      ff = 0; 
    end
    % ** simulation after fault clearing **
    flag = -1*ones(1,NW); %traditional controller
    flag_pv = -1*ones(1,NP); %-1: use traditional controller
    x0_dae = init_x; %equilibrium
    options = odeset('Mass',Mwo,'RelTol', tol,'AbsTol', tol); 
    [t,x] = ode15s(@psm_15s,[0:0.01:sims.te], init_x+ds, options);sims.odemem = 0;

    % save
    traj{lops}.t = [tf; t];
    traj{lops}.x = [xf; x];
  end
  
  % Save data
  [v,e] = eig(sys.A); 
  res{lops}.v = v; 
  res{lops}.e = diag(e); 
  res{lops}.flag = isstable(sys.A); 
  res{lops}.gam = gs(lops);

  j=1;
  linearization_pv;
  [tmp, res{lops}.bw_w] = sigma(ss(lin_pv{j}.A, lin_pv{j}.R, lin_pv{j}.Pow, [])); 
  res{lops}.bw_m = 20*log10(tmp);
  
  % exit at final loop 
  if(lops == length(gs)); break; end

  % Clear
  clearvars -except res gs lops gpl fTran sims traj
  global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
  global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk n_ode ff Ykc init_EW 
  global net_f fcase Yf Yf_wof init_x
  global ir_s is_s ws vdc_s Q_s
  global Yg Yg_iw Yg_ipv wr_s
  global P_spv Q_spv ipv_s mG_s pv flag_pv
  
end
save('mot_PV.mat','res','gs','lops','gpl','fTran','sims');

% ===== Plot eigenvalue variation =====
figure; hold on; 
for lp = 1:length(gs)
  e = res{lp}.e;
  if(lp==gpl(1))
    plot(real(e), imag(e), 'o','Color', [0 0 1], 'MarkerSize', 10, 'linewidth',2); 
  elseif(lp==gpl(2))
    plot(real(e), imag(e), '^','Color', [0 0.9 0], 'MarkerSize', 10, 'linewidth',2); 
  elseif(lp==gpl(3))
    plot(real(e), imag(e), 's','Color',[1 0 0], 'MarkerSize', 10, 'linewidth',2); 
  else
    plot(real(e), imag(e), 'kx', 'MarkerSize', 10, 'linewidth',1); 
  end
end
grid on; xlim([-0.2 0.02]); ylim([-2.5 2.5]); 
% ===== Sigma plot of wind =====
if 1
  figure; 
  semilogx(1/(2*pi)*res{1}.bw_w, res{1}.bw_m, 'b-');hold on; 
  for lp = 2:2:length(gs)-1
    semilogx(1/(2*pi)*res{lp}.bw_w, res{lp}.bw_m, 'k-');
  end
  semilogx(1/(2*pi)*res{end}.bw_w, res{end}.bw_m, 'r-'); grid on; xlabel('freq (Hz)'); ylabel('gain(dB)');
  xlim([0.1 1]); ylim([-10 60]);
end
% ===== Plot transient simulation result =====
if fTran~=0
  %col = [0 0 1; 1 0 0; 0 0.8 0; 1 1 0; 0.5 0.5 0.1]; 
  col2 = [0 0 1; 0 0.8 0; 1 0 0];
  figure; hold on; 
  for kk= length(gpl):-1:1
    lp = gpl(kk);
    % add pre fault trajectories for journal
    %[t,x] = add_prefault_traj(res{lp}.t, res{lp}.x,-1); 
    t = traj{lp}.t; x = traj{lp}.x; 
    % calculate some physical quantities
    sims.type = 1; cal_sg; 
    % plot
    if 0
      pl01;
    else
      subplot(1,3,kk);
      %plot(t, ome,'-','Color',col2(kk,:),'linewidth',1); hold on; ylabel('ome[Hz]'); 
      plot(t, ome,'b-','linewidth',1); hold on; %ylabel('ome[Hz]'); 
      grid on; xlim([0 40]); ylim([-0.05 0.05]); 
      set(gca,'Xtick', [0 20 40]);set(gca,'Ytick', [-0.04 -0.02 0 0.02 0.04])
    end
  end
end


if 1   
  load('mot_PV.mat');
  figure; subplot(1,2,1);
  semilogx(1/(2*pi)*res{1}.bw_w, max(res{1}.bw_m), 'b-');hold on; 
  for lp = 2:2:length(gs)-1
    semilogx(1/(2*pi)*res{lp}.bw_w, max(res{lp}.bw_m), 'k-');
  end
  semilogx(1/(2*pi)*res{end}.bw_w, max(res{end}.bw_m), 'r-'); grid on; xlabel('freq (Hz)'); ylabel('gain(dB)');
  xlim([0.1 1]); ylim([-20 60]); 

  load('mot_wind.mat');
  subplot(1,2,2);
  semilogx(1/(2*pi)*res{1}.bw_w, max(res{1}.bw_m), 'b-');hold on; 
  for lp = 2:2:length(gs)-1
    semilogx(1/(2*pi)*res{lp}.bw_w, max(res{lp}.bw_m), 'k-');
  end
  semilogx(1/(2*pi)*res{end}.bw_w, max(res{end}.bw_m), 'r-'); grid on; xlabel('freq (Hz)'); 
  xlim([0.1 1]); ylim([-20 60]); 
end  
  