%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Eigenvalue variation by changing Wind penetration level
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all; pause(0.1); addpath('./tool/');
global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk n_ode ff Ykc init_EW 
global net_f fcase Yf Yf_wof init_x
global ir_s is_s ws vdc_s Q_s
global Yg Yg_iw Yg_ipv wr_s
global P_spv Q_spv ipv_s mG_s pv flag_pv
global compw_pv
global flag_g addPSSu gl sys

%% penetration levels of solar
gs = linspace(0.2, 16, 20); 
gpl = findsimilar(gs, [0.2, 10, 15], 'i');
%gs = linspace(1, 1000, 10); 
%gpl = findsimilar(gs, [1, 100, 1000], 'i');
res = cell(1, length(gs));
sims.type = 1;

% Flag for transient somulation
fTran = 0; 

for lops=1:length(gs)
  % **** Initial Settings ****
  % penetration of wind (connected bus#, reactance, P[MW])
  data_wind01;
  % penetration level of wind farm
  gamma = [80]; 
  
  % penetration of solar
  gamma_pv = 0; %pv farm
  data_pv01;
  
  % penetration level of storage
  mu = [0]; 

  % ****** CHANGE GAIN *******
  % 6-Kp_dR
  % 7-Ki_dR
  % 8-Kp_qR
  % 9-Ki_qR
  % 14-KdPR (d-axis P gain of outer loop of RSC) 
  % 15-KdIR (d-axis I gain of outer loop of RSC)
  % 16-KqPR (q-axis P gain of outer loop of RSC)
  % 17-KqIR (q-axis I gain of outer loop of RSC)
  %winp(1,6) = gs(lops);
  %winp(1,8) = gs(lops);
  winp(1,7) = gs(lops);
  winp(1,9) = gs(lops);
  
  % fault bus
  sims.fbus = 69;
  
  fprintf(' ********** Gain = %.1f ***********\n', gs(lops)); 
  
  % Select a power network to be simulated
  data_68bus;
  
  % Power flow calculation
  pflow;
  % Pre-calculation
  precalc;
  % Initial settings
  init_state; 
  % error check
  flag = -1*ones(1,NW); %-1: use traditional controller
  flag_pv = -1*ones(1,NP); %-1: use traditional controller
  flag_g = -1; %without use global controller
  delPW = [0;0]; 
  ff = 0; %0: power line fault flag off
  n_ode = n; %dimension of whole system
  dx = psm_15s(0, init_x);
  if(norm(dx) > 1e-5); error('failed determining initial state'); end
  
  % Linearization 
  linearization_all;

  j=1;
  linearization;
  [v,e] = eig(lin{j}.A); 
  res{lops}.vw = v; 
  res{lops}.ew = diag(e); 
  [tmp, res{lops}.bw_w] = sigma(ss(lin{j}.A, lin{j}.R, lin{j}.Cur, [])); 
  res{lops}.bw_m = 20*log10(tmp);

  % ======== fault simulation if you want ========
  if fTran~=0 & ismatch(gpl,lops)
    if(fTran == 2)
      load('ds_wind01.mat'); 
      tf = []; xf = [];
     elseif(fTran == 1)
       ds = zeros(n,1); 
       fprintf('[ Fault Simulation (Bus = %d)]\n', sims.fbus);
       make_fault_settings; % do settings

       % ** determine initial disturbance **
       % Note:  state = genstate; EL; EW; EP and ELF
       n_ode = n; 
       flag = -1*ones(1,NW); %traditional controller
       flag_pv = -1*ones(1,NP); %-1: use traditional controller
       x0_dae = init_x; %equilibrium
       ff = 1; %fault flag on
       options = odeset('Mass',Mf,'RelTol',1e-8,'AbsTol',1e-8);
       [tf,xf] = ode15s(@psm_15s,[-sims.ft:0.001:0], init_xf, options);sims.odemem = 0;
       ds = xf(end, 1:n)'-init_x(1:n); 
       tf = tf(1:end-1); xf = xf(1:end-1, :); 
       ff = 0; 
end    
    % ** simulation after fault clearing **
    flag = -1*ones(1,NW); %traditional controller
    flag_pv = -1*ones(1,NP); %-1: use traditional controller
    x0_dae = init_x; %equilibrium
    options = odeset('Mass',Mwo,'RelTol', tol,'AbsTol', tol); 
    [t,x] = ode15s(@psm_15s,[0:0.01:sims.te], init_x+ds, options);sims.odemem = 0;
    
    % save
    res{lops}.t = [tf; t];
    res{lops}.x = [xf; x];
  end
  
  % Save data
  [v,e] = eig(sys.A); 
  res{lops}.v = v; 
  res{lops}.e = diag(e); 
  res{lops}.flag = isstable(sys.A); 
  res{lops}.gam = gs(lops);
  res{lops}.x0 = xw{1}; 
  
  % exit at final loop 
  if(lops == length(gs)); break; end

  % Clear
  clearvars -except res gs lops gpl fTran sims
  global net NG NL NW NP gpar dae Vref vfdstar win flag mpc pm sims
  global compwo compw lin delPW ystar init_PL init_EL init_PP init_IP YL x0_dae Yk n_ode ff Ykc init_EW 
  global net_f fcase Yf Yf_wof init_x
  global ir_s is_s ws vdc_s Q_s
  global Yg Yg_iw Yg_ipv wr_s
  global P_spv Q_spv ipv_s mG_s pv flag_pv
  
end

% ===== Plot eigenvalue variation =====
figure; hold on; 
for lp = 1:length(gs)
  e = res{lp}.e;
  if(lp==gpl(1))
    plot(real(e), imag(e), 'o','Color', [0 0 1], 'MarkerSize', 10, 'linewidth',2); 
  elseif(lp==gpl(2))
    plot(real(e), imag(e), '^','Color', [0 0.9 0], 'MarkerSize', 10, 'linewidth',2); 
  elseif(lp==gpl(3))
    plot(real(e), imag(e), 's','Color',[1 0 0], 'MarkerSize', 10, 'linewidth',2); 
  else
    plot(real(e), imag(e), 'kx', 'MarkerSize', 10, 'linewidth',1); 
  end
end
grid on; xlim([-0.05 0.02]); ylim([-2.5 2.5]);


% ===== Plot of wind eigenvalue variation =====
if 1
  figure; hold on; 
  for lp = 1:length(gs)
    e = res{lp}.ew;
    if(lp==gpl(1))
      plot(real(e), imag(e), 'o','Color', [0 0 1], 'MarkerSize', 10, 'linewidth',2); 
    elseif(lp==gpl(2))
      plot(real(e), imag(e), '^','Color', [0 0.9 0], 'MarkerSize', 10, 'linewidth',2); 
    elseif(lp==gpl(3))
      plot(real(e), imag(e), 's','Color',[1 0 0], 'MarkerSize', 10, 'linewidth',2); 
    else
      plot(real(e), imag(e), 'kx', 'MarkerSize', 10, 'linewidth',1); 
    end
  end
  grid on; xlim([-0.05 0.02]); ylim([-2.5 2.5]); title('wind eigs');
end

% ===== Sigma plot of wind =====
if 0
  figure; 
  semilogx(res{1}.bw_w, res{1}.bw_m, 'b-');hold on; 
  for lp = 2:length(gs)-1
    semilogx(res{lp}.bw_w, res{lp}.bw_m, 'k-');
  end
  semilogx(res{end}.bw_w, res{end}.bw_m, 'r-'); grid on; xlabel('freq (rad/s)'); ylabel('gain(dB)');
end


