%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fault settings
%    fbus: fault bus number
% This function is used to do 3-phase fault simulation. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% rename
fbus = sims.fbus;

% copy 
bus_f = bus; 

% **** Define the following in each case below ****
% Case 1) fault happens at gen, load, wind, or PV bus
% Case 0) fault happens at the other bus
%
% Define: 
% A)  node-admittance matrix Yf such that 
%       Case 1) [IG; IL; IW; IP] = Yf * [VG; VL; VW; VP]
%       Case 0) [IG; IL; IW; IP; IF] = Yf * [VG; VL; VW; VP; VF]
% B)  index of fault bus voltage & current
%
if ~isempty(intersect([bus.nG;bus.nL;bus.nW;bus.nP], [2*fbus-1; 2*fbus]))
  fcase = 1;

  % === A) "augmented real" node-admittance matrix  (in case 0, same as health one) ===
  Yf = Yk; 

  % index of fault bus
  E = [EYE(bus.N, bus.nG)'; EYE(bus.N, bus.nL)'; EYE(bus.N, bus.nW)'; EYE(bus.N, bus.nP)'; EYE(bus.N, bus.nN)']; 
  nod_f = nod; 
  nod_f.F = find(sum((E*EYE(bus.N, [2*fbus-1; 2*fbus]))') == 1); 

  % === B) index of fault bus voltage & current ===
  net_f = net; 
  net_f.EFi = net.n + [nod_f.F];
  
else
  fcase = 0;

  % ***** define fault bus-admittance matrix *****
  bus_f.nF = [2*fbus-1; 2*fbus];
  bus_f.nN = setxor([1:bus.N], [bus.nG; bus.nL; bus.nW; bus.nP; bus_f.nF]);
  
  E = [EYE(bus.N, bus.nG)'; EYE(bus.N, bus.nL)'; EYE(bus.N, bus.nW)'; EYE(bus.N, bus.nP)'; EYE(bus.N, bus_f.nF)'; EYE(bus.N, bus_f.nN)']; 

  %permutated "augmented real" bus-admittance matrix
  Ypf = E*comp2augreal(full(y_sparse(mpc.bus, mpc.branch)),'mat')*E';

  %Kron reduction
  node = [1:2*(NG+NL+NW+NP+1)]; 
  nbus = setxor([1:bus.N]', node); %buses connecting to no nodes
  
  Ynn = Ypf(node, node);
  Ynb = Ypf(node, nbus);
  Ybn = Ypf(nbus, node);
  Ybb = Ypf(nbus, nbus);

  % === A) "augmented real" node-admittance matrix ===
  Yf = Ynn - Ynb*inv(Ybb)*Ybn; 
  Yf_wof = Yf(1:2*(NG+NL+NW+NP), 1:2*(NG+NL+NW+NP)); 
  
  % fault bus index
  nod_f = nod; 
  nod_f.F = [2*(NG+NL+NW+NP)+1:2*(NG+NL+NW+NP)+2]; % newly define fault node

  % === B) index of fault bus voltage & current ===
  net_f = net; 
  net_f.EFi = net.n + [nod_f.F];
  net_f.nDAE = net_f.nDAE + 2; 
end

% ======= define initial state =======
% fcase = 1) fault happens at gen, load, wind, or PV bus
% fcase = 0) fault happens at the other bus

% define internal voltage vector & direct term in syncgen output
ieg = zeros(2*NG, 1); D = zeros(2*NG, 2*NG);
for j=1:NG
  xdp = gpar{j}.xdp; 
  E = xk{j}(3); del = xk{j}(1);
  ieg(2*j-1:2*j) = (1/xdp)*[E*sin(del); E*cos(del)]; 
  D(2*j-1:2*j, 2*j-1:2*j) = [0, -1/xdp; 1/xdp, 0]; 
end

if fcase
  Ynew = Yf + blkdiag(-D, YL, zeros(2*NW), zeros(2*NP)); 
  P = eye(2*(NG+NL+NW+NP)); 
  P(nod_f.F, :) = []; %truncation matrix
  V = P'*inv(P*Ynew*P')*P*[ieg; zeros(2*NL,1); init_IW; init_IP];
  init_xf = [init_x(1:net.n); V]; 
else
  
  %"augmented real" (generator, wind, PV, fault bus)-admittance matrix
  tmp = [nod.G,nod.W,nod.P,nod_f.F]; 
  Yfgp = Yf(tmp, tmp) - Yf(tmp, nod.L)*inv(YL + Yf(nod.L,nod.L))*Yf(nod.L,tmp);
  Y11 = Yfgp(1:2*NG, 1:2*NG); 
  Y12 = Yfgp(1:2*NG, 2*NG+1:2*(NG+NW+NP)); 
  Y21 = Yfgp(2*NG+1:2*(NG+NW+NP), 1:2*NG); 
  Y22 = Yfgp(2*NG+1:2*(NG+NW+NP), 2*NG+1:2*(NG+NW+NP)); 
  Yfg_g = Y11 - Y12*inv(Y22)*Y21; 
  Yfg_wp = Y12*inv(Y22); 
  
  EG = inv(D - Yfg_g)*(Yfg_wp*[init_IW; init_IP] - ieg); 
  tmps = inv(Y22)*([init_IW; init_IP] - Y21*EG); 
  EW = tmps(1:2*NW);
  EP = tmps(2*NW+1:end);
  EF = [0;0]; 
  EL = -inv(YL+Yf(nod.L, nod.L))*Yf(nod.L, tmp)*[EG;EW;EP;EF]; 

  % Note:  state = state of gen, wind, storage; EG; EL; EW; EP; and EF
  init_xf = [init_x(1:net.n); [EG;EL;EW;EP;EF]];

end

n_f = length(init_xf); %dimension
Mf = blkdiag(eye(net.n), zeros(n_f-net.n)); %inertia for DAE
