%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Linearization of wind power plant
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ***** set initial state *****
lin_pv{j}.x0 = xpv{j};
lin_pv{j}.n = pv{j}.n;
lin_pv{j}.m = pv{j}.m;

% ***** original nonlinear funtion *****
f = @(x, vgrid, u) pv{j}.f(x, vgrid, P_spv{j}, Q_spv{j}, Spv_s{j}, u);   

% check
vstar = init_EP(2*j-1:2*j);
ustar = zeros(lin_pv{j}.m,1); 
if(norm(f(lin_pv{j}.x0, vstar, ustar)) > 1e-6)
  error('failure to define original nonlinear Sigma.'); 
end

% ***** numerical derivative *****
h = 1e-8; %step size

lin_pv{j}.A = zeros(lin_pv{j}.n);
for k=1:lin_pv{j}.n
  e = h*EYE(lin_pv{j}.n, k);
  lin_pv{j}.A(:,k) = (f(lin_pv{j}.x0 + e, vstar, ustar) - f(lin_pv{j}.x0, vstar, ustar))/h; 
end

% input port w.r.t. retrofit control
lin_pv{j}.B = zeros(lin_pv{j}.n, lin_pv{j}.m);
for k=1:lin_pv{j}.m
  lin_pv{j}.B(:,k) = (f(lin_pv{j}.x0, vstar, h*EYE(lin_pv{j}.m, k)) - f(lin_pv{j}.x0, vstar, ustar))/h;   
end

% input port w.r.t. external signal
lin_pv{j}.R = zeros(lin_pv{j}.n, 2);
for k=1:2
  lin_pv{j}.R(:,k) = (f(lin_pv{j}.x0, h*EYE(2, k) + vstar, ustar) - f(lin_pv{j}.x0, vstar, ustar))/h;   
end

lin_pv{j}.Pow = zeros(2, lin_pv{j}.n);
lin_pv{j}.Cur = zeros(2, lin_pv{j}.n);
for k=1:lin_pv{j}.n
  e = h*EYE(lin_pv{j}.n, k);
  lin_pv{j}.Pow(:,k) = (pv{j}.pow(vstar,lin_pv{j}.x0+e) - pv{j}.pow(vstar,lin_pv{j}.x0))/h;   
  lin_pv{j}.Cur(:,k) = (pv{j}.cur(lin_pv{j}.x0+e) - pv{j}.cur(lin_pv{j}.x0))/h;   
end
lin_pv{j}.PowD = gamma_pv(j)*[ig_spv{j}(1), ig_spv{j}(2); -ig_spv{j}(2), ig_spv{j}(1)]; 

%check stability and controllability of linearized model
if(max(real(eig(lin_pv{j}.A))) < -1e-8)
  fprintf('linearized model is stable\n');
  tmp = lyapchol(lin_pv{j}.A, lin_pv{j}.B); 
  gramc = tmp'*tmp;
  [v,lam] = eig(gramc); lam = diag(lam);
  lam
else
  fprintf('linearized model is unstable\n');
end

% ***** define nonlinear part *****
lin_pv{j}.F = @(x, v, u)  f(x, v, u) - lin_pv{j}.A*x - lin_pv{j}.B*u; 
[lin_pv{j}.sig, lin_pv{j}.w] = sigma(ss(lin_pv{j}.A, lin_pv{j}.R, lin_pv{j}.Pow, lin_pv{j}.PowD)); 

