%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Linearization of wind-integrated system
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% *****  numerical derivative  *****
% step size
h = 1e-7; 

% linearized A
x0 = init_x;

tmpA = zeros(n);
for k=1:n
  %unit vector, k-th column of I_n
  e = EYE(n,k); 
  tmpA(:,k) = (psm_15s(0,x0+h*e) - psm_15s(0,x0))/h; 
end

%partion of A
%1 , 2 are compatible with syncgen+wind plant+battery, bus voltage
A11 = tmpA(1:net.n, 1:net.n); 
A12 = tmpA(1:net.n, net.n+1:end); 
A21 = tmpA(net.n+1:end, 1:net.n); 
A22 = tmpA(net.n+1:end, net.n+1:end); 

%kron-reduction
sys.A = A11 - A12*inv(A22)*A21;
sys.n = size(sys.A, 1);
sys.index = [1:net.n];

%check stability of linearized model
eigA = eig(sys.A); 
[tmp1,tmp2] = sort(real(eigA)); 
eigA(tmp2(end-5:end))
if(max(real(eig(sys.A))) < 0)
  fprintf('linearized overall system is stable\n');
else
  fprintf('linearized overall system is unstable\n');
end

% decompose A into sub A for retrofit on pre-existing grid
sys.Ag = sys.A(1:net.ng, 1:net.ng); 
sys.Rg = sys.A(1:net.ng, net.ng+1:end); 

% PSS input
tmpB = zeros(n, NG);
for k=1:NG
  %unit vector, k-th column of I_n
  e = EYE(n,k); 
  flag_g = 0; %for linearization only

  addPSSu = zeros(NG,1); 
  addPSSu(k) = h; 
  be = psm_15s(0,x0); 
  
  addPSSu(k) = 0; 
  b0 = psm_15s(0,x0); 
  
  tmpB(:,k) = (be-b0)/h; 
end
flag_g = -1; %without use Global controller
sys.B = tmpB(1:net.ng,:); 

% gen frequency 
sys.C = EYE(net.ng, out.ome)';

%system from e_wind to |v|_wind
if 0
  tmpB = zeros(n,2);
  delPW = [0;0]; 
  v = init_EW(1:2);
  for k=1:2
    delPW(k) = h; 
    be = psm_15s(0,x0);
    
    delPW(k) = 0; 
    b0 = psm_15s(0,x0);    
    tmpB(:,k) = (be-b0)/h; 
  end
  delPW = [0;0]; 
  
  tmpB = tmpB(net.ng+1:net.ng+net.nDAE, :);
  tmpC = (1/norm(v))*v'*EYE(net.nDAE, net.EWi-net.ng)';
  
  sys_syncg = ss(A11-A12*inv(A22)*A21, -A12*inv(A22)*tmpB, -tmpC*inv(A22)*A21, -tmpC*inv(A22)*tmpB);
  sigma(sys_syncg);
  [vs,es] = eig(sys_syncg.A); es = diag(es);
  figure; plot(real(es), imag(es), 'bo'); grid on; xlim([-0.4 0.07]); ylim([-5 5]); 

  
end