%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Linearization of wind power plant
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ***** set initial state *****
lin{j}.x0 = xw{j};
lin{j}.n = win{j}.n;
lin{j}.m = win{j}.m;

% ***** original nonlinear funtion *****
f = @(x, vgrid, u) win{j}.f(x, vgrid, wr_s{j}, ir_s{j}, vdc_s{j}, Q_s{j}, init_EW(2*j-1:2*j), wind_con(j,5), u);   

% check
vstar = init_EW(2*j-1:2*j);
ustar = zeros(lin{j}.m,1); 
if(norm(f(lin{j}.x0, vstar, ustar)) > 1e-6)
  error('failure to define original nonlinear Sigma.'); 
end

% ***** numerical derivative *****
h = 1e-8; %step size

lin{j}.A = zeros(lin{j}.n);
for k=1:lin{j}.n
  e = h*EYE(lin{j}.n, k);
  lin{j}.A(:,k) = (f(lin{j}.x0 + e, vstar, ustar) - f(lin{j}.x0, vstar, ustar))/h; 
end

% input port w.r.t. retrofit control
lin{j}.B = zeros(lin{j}.n, lin{j}.m);
for k=1:lin{j}.m
  lin{j}.B(:,k) = (f(lin{j}.x0, vstar, h*EYE(lin{j}.m, k)) - f(lin{j}.x0, vstar, ustar))/h;   
end

% input port w.r.t. external signal
lin{j}.R = zeros(lin{j}.n, 2);
for k=1:2
  lin{j}.R(:,k) = (f(lin{j}.x0, h*EYE(2, k) + vstar, ustar) - f(lin{j}.x0, vstar, ustar))/h;   
end

lin{j}.Pow = zeros(2, lin{j}.n);
lin{j}.Cur = zeros(2, lin{j}.n);
for k=1:lin{j}.n
  e = h*EYE(lin{j}.n, k);
  lin{j}.Pow(:,k) = (win{j}.pow(vstar,lin{j}.x0+e) - win{j}.pow(vstar,lin{j}.x0))/h;   
  lin{j}.Cur(:,k) = (win{j}.cur(lin{j}.x0+e) - win{j}.cur(lin{j}.x0))/h;   
end
lin{j}.PowD = gamma(j)*[is_s{j}(1), is_s{j}(2); -is_s{j}(2), is_s{j}(1)]; 

%check stability and controllability of linearized model
if(max(real(eig(lin{j}.A))) < -1e-8)
  fprintf('linearized model is stable\n');
  tmp = lyapchol(lin{j}.A, lin{j}.B); 
  gramc = tmp'*tmp;
  [v,lam] = eig(gramc); lam = diag(lam);
  lam
else
  fprintf('linearized model is unstable\n');
end

% ***** define nonlinear part *****
lin{j}.F = @(x, v, u)  f(x, v, u) - lin{j}.A*x - lin{j}.B*u; 
[lin{j}.sig, lin{j}.w] = sigma(ss(lin{j}.A, lin{j}.R, lin{j}.Pow, lin{j}.PowD)); 


% input - all duty      outut - vdc
sys_vdc = ss(lin{j}.A, lin{j}.B, EYE(win{j}.n, 16)', []); 
H2_to_vdc = norm(sys_vdc);
