%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate initial state
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%voltage
init_EG = init_E(nod.G);
init_EL = init_E(nod.L);
init_EW = init_E(nod.W);
init_EP = init_E(nod.P);

%power
init_PG = init_P(nod.G);
init_PL = init_P(nod.L); 
init_PW = init_P(nod.W); 
init_PP = init_P(nod.P); 

%current
init_IL = init_I(nod.L); 
init_IW = init_I(nod.W); 
init_IP = init_I(nod.P); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ************  find initial states of sync. generators and pss ************
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
v = comp2augreal(init_EG, 'vec', 'inv');
options = optimset('TolFun', 1e-8);
xk = cell(NG,1);
pm=zeros(NG,1); %mechanical input[pu]
Vref=zeros(NG,1); %reference voltage given by AVR[pu]
vfdstar=zeros(NG,1); %reference voltage given by AVR[pu]

for j=1:NG
  V = abs(v(j));
  th= angle(v(j));   
  P = init_PG(2*j-1); 
  Q = init_PG(2*j); 
  
  xdp= gpar{j}.xdp;
  xd= gpar{j}.xd;
  xq = gpar{j}.xq;

  % ******** equilibrium ********
  xk{j} = zeros(gpar{j}.n,1);  
  
  xk{j}(1) = th + atan(P/(Q+V^2/xq)); 
  xk{j}(2) = 0; 
  xk{j}(3) = (V^4 + Q^2*xdp*xq + Q*V^2*xdp + Q*V^2*xq + P^2*xdp*xq)/(V*sqrt(P^2*xq^2 + Q^2*xq^2 + 2*Q*V^2*xq + V^4));
  xk{j}(4) = xd/xdp*xk{j}(3) - (xd/xdp-1)*V*cos(xk{j}(1) - th);
  xk{j}(5:7) = [0;0;0]; %state of pss 
  
  pm(j) = P; %pm
  Vref(j) = V;
  vfdstar(j) = xd/xdp*xk{j}(3) - (xd/xdp-1)*V*cos(xk{j}(1) - th);
  
  % ******** check ********
  Vd = real(v(j));  Vq = imag(v(j)); 
  
  f = @(x) [P;Q]-dae{j}.pow(x, V, th); 
  if(norm(f(xk{j})) > 1e-7); error('no solution'); end

  f = @(x) dae{j}.dxk(x, pm(j), V, th, V, vfdstar(j),0);
  if(norm(f(xk{j})) > 1e-7); error('no solution for state of sync.gen'); end
  
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% find initial states of solar farms
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xpv= cell(NW,1); 
ipv_s= cell(NW,1);

for j=1:NP
  vgrid = init_EP(2*j-1:2*j); %grid voltage
  pow = init_PP(2*j-1:2*j); %power to grid 
  Lg = pv{j}.Lg;
  Rg = pv{j}.Rg;
  Gdc = pv{j}.Gdc;
  options = optimset('TolFun', 1e-8); %option for solving algebraic equations
  
  % ================================================
  % x := [idg; iqg; chi_d; chi_q; Zeta_dg; Zeta_qg; vdc] (i, inner, outer, dc)
  % u = [u for AC/DC]
  % ================================================
  ig = inv([vgrid(1), vgrid(2); vgrid(2), -vgrid(1)])*(-pow/gamma_pv(j)); 
  chi = ig; 
  zeta = ig;
  p_inp = pow(1)/gamma_pv(j) + Rg*ig'*ig; 

  vdc = sqrt((pv{j}.P_s - p_inp)/(2*Gdc)); 
  
  x0nl = [ig; chi; zeta; vdc]; 
  Spv = pv{j}.Vdcp_s/vdc;
  idc = Spv*pv{1}.ipv_s;
  
  % find exact equilibirum 
  f = @(x) [pv{j}.f(x, vgrid, pow(1), pow(2), Spv, [0;0]); pow-pv{j}.pow(vgrid,x)];
  [x0,fval,exitflag,output,jacob]=fsolve(@(x) f(x), x0nl, options);  
  
  % ***** set initial state *****
  xpv{j} = x0(1:pv{j}.n);
  P_spv{j} = pow(1);
  Q_spv{j} = pow(2);
  Spv_s{j} = Spv;
  ig_spv{j} = ig;
  mG_spv{j} = pv{j}.mG(x0(1:6), x0(7), vgrid, P_spv{j}, Q_spv{j}, [0;0]);
  
  if norm(max(min(mG_spv{j}, 1),-1) - mG_spv{j})>1e-6
    fprintf('Duty of AC/DC of PV is larger than 1;  (d-axis=%.1f, q-axis=%.1f)\n',mG_spv{j}(1),mG_spv{j}(2));
  end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% find initial states of wind power plants
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xw= cell(NW,1); 
ir_s= cell(NW,1);
xs= cell(NW,1);

for j=1:NW
  % parameters of wind 
  Xm = win{j}.Xm;
  Xs = win{j}.Xs;
  Xr = win{j}.Xr;
  Rs = win{j}.Rs;
  Rr = win{j}.Rr;
  Ng = win{j}.Ng; 
  Shm = win{j}.Shm; 
  Shl = win{j}.Shl; 
  
  vgrid = init_EW(2*j-1:2*j); %grid voltage
  vs = Shm*vgrid; %stator voltage
  vg = Shl*vgrid; %converter-side voltage
  pow = init_PW(2*j-1:2*j); %power to grid 
  options = optimset('TolFun', 1e-8); %option for solving algebraic equations
  
  % ================================================
  % consider B2B
  % xwin := [eta^T, xi^T, xB2B^T]^T 
  %    where xi = [idr iqr ids iqs],
  %         xB2B = [idg; iqg; Didg; Diqg; Zeta_dg; Zeta_qg; Didr;Diqr; OC_d;OC_q;vdc]
  %               u = [u for mdG, mqG, mdR, mqR]
  % ================================================
  Lg = win{j}.Lg;
  Rg = win{j}.Rg;
  Gdc = win{j}.Gdc;
  
  % analytical solution
  is = @(Didg, Diqg)  inv([vs(1), vs(2); vs(2), -vs(1)])*(pow/gamma(j) + [vg(1), vg(2); vg(2), -vg(1)]*[Didg; Diqg]); 
  ir = @(Didg, Diqg) inv([0, Xm; -Xm, 0])*(vs - [-Rs, Xs; -Xs, -Rs]*is(Didg, Diqg));
  vr = @(Didg, Diqg, wr)  [-Rr, Xr*(1-wr); Xr*(wr-1), -Rr]*ir(Didg, Diqg) + [0, Xm*(1-wr); Xm*(wr-1), 0]*is(Didg, Diqg); 
  
  if sto_flag == 1
    Lb = win{j}.Lb;
    Rb = win{j}.Rb;
    Gb = win{j}.Gb;
    Cb = win{j}.Cb;
    Ss = win{j}.Ss;
    vdc = @(Didg, Diqg, wr)  ...
	sqrt(1/(2*Gdc+Gb/(1+Gb*Rb)*Ss^2)*(vg'*[Didg; Diqg] + vr(Didg, Diqg, wr)'*ir(Didg, Diqg)-Rg*(Didg^2+Diqg^2)));       
  else
    vdc = @(Didg, Diqg, wr)  sqrt(1/(2*Gdc)*(vg'*[Didg; Diqg] + vr(Didg, Diqg, wr)'*ir(Didg, Diqg)-Rg*(Didg^2+Diqg^2))); 
  end
  
  if winp(j,12) == 1
    % ****** Pg_s, Qg_s are desirable ******
    Pg_s = winp(j,10);
    Qg_s = winp(j,11);
    ig = inv([vg(1), vg(2); vg(2), -vg(1)])*[Pg_s; Qg_s];
    
    Didg = ig(1); Diqg = ig(2);
    
    is_ = is(Didg,Diqg);
    ir_ = ir(Didg,Diqg);
    tg = Xm*(is_(1)*ir_(2) - is_(2)*ir_(1)); 
    
    Pa = win{j}.pa*(wind_con(j,5)^3); 
    Ng = win{j}.Ng;
    Bl = win{j}.Bl;
    Br = win{j}.Br;
    Kc = win{j}.Kc;
    wl = (-Ng*tg + sqrt((Ng*tg)^2 + 4*Pa*(Bl+Br*Ng*Ng)))/(2*(Bl+Br*Ng*Ng));
    wr = Ng*wl; 
    th = (Ng/Kc) * (tg + Br*Ng*wl); 
    vr_ = vr(Didg, Diqg, wr); 
    vdc_ = vdc(Didg, Diqg, wr); 
    
    if sto_flag == 1
      vbs = sto_con(j,5)*vdc_/(1+Gb*Rb); 
      idcPs = -Gb*sto_con(j,5)*vdc_/(1+Gb*Rb); 
    end
    
    if RSC_flag == 1
      x0nl = [wl;wr;th;ir_;is_;Didg;Diqg;Didg;Diqg;Didg;Diqg;vr_;ir_;vdc_]; 
    else
      if sto_flag == 1
	x0nl = [wl;wr;th;ir_;is_;Didg;Diqg;Didg;Diqg;Didg;Diqg;vr_;vdc_;vbs;idcPs]; 
      else
	x0nl = [wl;wr;th;ir_;is_;Didg;Diqg;Didg;Diqg;Didg;Diqg;vr_;vdc_]; 
      end
    end
  end        
  % find exact equilibirum 
  if sto_flag == 1
    f = @(x) [win{j}.f(x, vgrid, EYE(win{j}.n,2)'*x, EYE(win{j}.n,4:5)'*x, vdc_, gamma(j)*Qg_s, vgrid, wind_con(j,5), [0;0;0;0;0]); pow-win{j}.pow(vgrid,x)];
    [x0,fval,exitflag,output,jacob]=fsolve(@(x) f(x), x0nl, options);  
  else
    f = @(x) [win{j}.f(x, vgrid, EYE(win{j}.n,2)'*x, EYE(win{j}.n,4:5)'*x, vdc_, gamma(j)*Qg_s, vgrid, wind_con(j,5), [0;0;0;0]); pow-win{j}.pow(vgrid,x)];
    [x0,fval,exitflag,output,jacob]=fsolve(@(x) f(x), x0nl, options);  
  end
  
  % ***** set initial state *****
  xw{j} = x0(1:win{j}.n);
  wr_s{j} = x0(2);
  ir_s{j} = x0(4:5);
  is_s{j} = x0(6:7);
  ig_s{j} = x0(8:9);
  vr_s{j} = x0(14:15);
  P_s{j} = gamma(j)*[vg(1), vg(2)]*x0(8:9);
  Q_s{j} = gamma(j)*[vg(2), -vg(1)]*x0(8:9);
  if RSC_flag == 1
    vdc_s{j} = x0(18);
  else
    vdc_s{j} = x0(16);
  end
  mG_s{j} = win{j}.mG(x0nl(8:13), vgrid, vdc_s{j}, vdc_s{j}, Q_s{j}, [0;0]);
  mR_s{j} = win{j}.mR(x0nl(14:15), ir_s{j}, ir_s{j}, vdc_s{j}, [0;0]);
  
  if norm(max(min(mG_s{j}, 1),-1) - mG_s{j})>1e-6
    fprintf('Duty of GSC is larger than 1;  (d-axis=%.1f, q-axis=%.1f)\n',mG_s{j}(1),mG_s{j}(2));
  elseif norm(max(min(mR_s{j}, 1),-1) - mR_s{j})>1e-6
    fprintf('Duty of RSC is larger than 1;  (d-axis=%.1f, q-axis=%.1f)\n',mR_s{j}(1),mR_s{j}(2));
  end
  
  if sto_flag==1
    S_s{j} = sto_con(j,5);
  end
end

%initial state
tmp = [];
for j=1:NW
  tmp = [tmp; xw{j}];
  %if mu(j)>0
  %  tmp = [tmp; xs{j}];
  %end
end

tmp2 = [];
for j=1:NP
  tmp2 = [tmp2; xpv{j}];
end
init_x = [sum(d_cell(xk)')'; tmp; tmp2; init_EG; init_EL; init_EW; init_EP];
