%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Global controller desgin
%  NOTE: Call after linearization_all
%
% Gen:
% dot{x} = sys.Ag*x + sys.Rg*x2 + sys.B*u,  x2 is state of renewable
% y         = sys.C*x
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ggain = linspace(1, 1000, 3);

for lp=1:length(ggain)
  Q = sys.C'*sys.C;
  gl.H = lqr(sys.Ag', sys.C', 0.1*ggain(lp)*eye(net.ng), eye(size(sys.C,1)))'; 
  gl.F = -lqr(sys.Ag, sys.B, 10*ggain(lp)*Q, eye(NG)); 
  gl.K = sys.Ag+sys.B*gl.F-gl.H*sys.C; 
  gl.x0 = zeros(net.ng,1); 
  gl.n = size(gl.K, 1);   

  tmpn = n + n_dae(ones(1,NW), ones(1,NP));
  %gl.si = [n+1:n+gl.n];
  gl.si = [tmpn+1:tmpn+gl.n];
  
  % step size
  h = 1e-7; 
  
  % linearized A
  %x0 = [init_x;gl.x0]; 
  x0 = [init_x;init_w;gl.x0]; 

  tmpA = zeros(length(x0)); 
  flag = 1*ones(1,NW);
  flag_g = 1;
  flag_pv = -1*ones(1,NP); 
  ff = 0; 
  n_ode = n + n_dae(flag, flag_pv); 
  for k=1:length(x0)
    e = h*EYE(length(x0), k); 
    tmpA(:,k) = (psm_15s(0, x0+e) - psm_15s(0, x0))/h; 
  end
  
  %partion of A
  A11 = tmpA(1:net.n, 1:net.n); 
  A12 = tmpA(1:net.n, net.n+1:net.n+net.nDAE); 
  A13 = tmpA(1:net.n, net.n+net.nDAE+1:end);
  A21 = tmpA(net.n+1:net.n+net.nDAE, 1:net.n); 
  A22 = tmpA(net.n+1:net.n+net.nDAE, net.n+1:net.n+net.nDAE); 
  A23 = tmpA(net.n+1:net.n+net.nDAE, net.n+net.nDAE+1:end);
  A31 = tmpA(net.n+net.nDAE+1:end, 1:net.n); 
  A32 = tmpA(net.n+net.nDAE+1:end, net.n+1:net.n+net.nDAE); 
  A33 = tmpA(net.n+net.nDAE+1:end, net.n+net.nDAE+1:end);
  
  %kron-reduction
  tmpA = [A11,A13;A31,A33] - [A12;A32]*inv(A22)*[A21,A23];

  %eigenvalues
  [tmpG{lp}.vec, E] = eig(tmpA); tmpG{lp}.E = diag(E); 
  
end
