%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function of power flow constraints
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ret = func_pf(x,mpc,bus,Ybus)

%power flow through network
I = Ybus * x; 
P = augreal_prod(augreal_conj(I), x);

%constraint:
%  active power for generators
%  voltage magnitude for generators
%  active and reactive power for loads
%  active and reactive power for PVs
%  injected current at the buses connecting to nothing

ret = [augreal_real(P(bus.nGw)) - mpc.bus(augreal_ind(bus.nGw,'inv'),4);...
  augreal_abs(x(bus.nG)) - mpc.bus(augreal_ind(bus.nG,'inv'),2);...
  augreal_real(P(bus.nL)) + mpc.bus(augreal_ind(bus.nL,'inv'),6);...
  augreal_imag(P(bus.nL)) + mpc.bus(augreal_ind(bus.nL,'inv'),7);...
  augreal_real(P(bus.nW)) - mpc.bus(augreal_ind(bus.nW,'inv'),4);...
  augreal_abs(x(bus.nW)) - mpc.bus(augreal_ind(bus.nW,'inv'),2);...
  augreal_real(P(bus.nP)) - mpc.bus(augreal_ind(bus.nP,'inv'),4);...
  augreal_imag(P(bus.nP)) - mpc.bus(augreal_ind(bus.nP,'inv'),5);...
  augreal_angle(x(bus.bG)) - (0/180*pi);...
  I(bus.nN)];
