%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Design retrofit controllers
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
index_w = 0; index_wo = 0; init_wo = []; init_w = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Design for Wind
%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:NW
  % ********************************************
  % Redefine a system for controller design
  % ********************************************    
  [newLC{j}.A, newLC{j}.B, newLC{j}.G, newLC{j}.P, newLC{j}.Pd, proj] = make_lowdim(lin{j}.A, lin{j}.B, nhat(j));
  lin{j}.nhat = size(newLC{j}.A, 1);
  
  % ********************************************
  % new local controller +  compensator
  %    xhat := [state of local;  state of compensator] 
  % ********************************************  
  if(lc_type(j)==1)
    % ===== state feedback based on LQR =====    
    Apsi = inv(win{j}.T)* newLC{j}.A * win{j}.T;
    Bpsi = inv(win{j}.T)* newLC{j}.B;
    Ppsi = lin{j}.Pow*win{j}.T;
    
    Q4 = EYE(nhat(j), [4:7])*EYE(nhat(j), [4:7])';
    Q5 = Ppsi'*Ppsi; 

    if sto_flag==1
      newLC{j}.F = -lqr(Apsi, Bpsi, 1e5*Q4 + 1e6*Q5, diag([1e2,1e2, 1,1,1e-2])*eye(lin{j}.m));
    else
      newLC{j}.F = -lqr(Apsi, Bpsi, 1e5*Q4 + 1e5*Q5, diag([1e4,1e6, 1,1])*eye(lin{j}.m));
    end
    newLC{j}.F = newLC{j}.F * inv(win{j}.T); 
    
    newLC{j}.n = 0;
    tmpA = newLC{j}.A + newLC{j}.B*newLC{j}.F; 

    compw{j}.u = @(xhat, x) newLC{j}.F*(newLC{j}.Pd*x - xhat); 
    compw{j}.f = @(xhat, x, v) [
      newLC{j}.A*xhat + newLC{j}.Pd*lin{j}.F(x, v, compw{j}.u(xhat, x)) + newLC{j}.G*x;
      ];  
  else  
  
  end
  % ===== controller state definition =====
  compw{j}.n = newLC{j}.n + lin{j}.nhat;
  compw{j}.si= [n+index_w+1:n+index_w+compw{j}.n];
  compw{j}.x0 = [zeros(newLC{j}.n,1); newLC{j}.Pd*lin{j}.x0];
  init_w = [init_w; compw{j}.x0]; 
  index_w = index_w+compw{j}.n; 
  
end


%%%%%%%%%%%%%%%%%%%%%%%%%%
% Design for PV
%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:NP
  % ********************************************
  % Redefine a system for controller design
  % ********************************************    
  [newLC_pv{j}.A, newLC_pv{j}.B, newLC_pv{j}.G, newLC_pv{j}.P, newLC_pv{j}.Pd, proj] = make_lowdim(lin_pv{j}.A, lin_pv{j}.B, nhat_pv(j));
  lin_pv{j}.nhat = size(newLC_pv{j}.A, 1);
  
  % ********************************************
  % new local controller +  compensator
  %    xhat := [state of local;  state of compensator] 
  % ********************************************  
  if(lc_type(j)==1)
    % ===== state feedback based on LQR =====
    Q1 = lin_pv{j}.Pow'*lin_pv{j}.Pow; 
    newLC_pv{j}.F = -lqr(newLC_pv{j}.A, newLC_pv{j}.B, 0*Q1 + 1e2*eye(net.npv), eye(lin_pv{j}.m));
    newLC_pv{j}.n = 0;
    tmpA = newLC_pv{j}.A + newLC_pv{j}.B*newLC_pv{j}.F; 

    compw_pv{j}.u = @(xhat, x) newLC_pv{j}.F*(newLC_pv{j}.Pd*x - xhat); 
    compw_pv{j}.f = @(xhat, x, v) [
      newLC_pv{j}.A*xhat + newLC_pv{j}.Pd*lin_pv{j}.F(x, v, compw_pv{j}.u(xhat, x)) + newLC_pv{j}.G*x;
      ];  
  else  
  
  end
  % ===== controller state definition =====
  compw_pv{j}.n = newLC_pv{j}.n + lin_pv{j}.nhat;
  compw_pv{j}.si= [n+index_w+1:n+index_w+compw_pv{j}.n];
  compw_pv{j}.x0 = [zeros(newLC_pv{j}.n,1); newLC_pv{j}.Pd*lin_pv{j}.x0];
  init_w = [init_w; compw_pv{j}.x0]; 
  index_w = index_w+compw_pv{j}.n; 
  
end

% ****** check ******
flag = 1*ones(1,NW);
flag_pv = 1*ones(1,NP); 
ff = 0; 
n_ode = n + n_dae(flag, flag_pv); 
dx = psm_15s(0, [init_x;init_w]);
if(norm(dx) > 1e-4); error('wrong local controller or compensator'); end

if 1
  % *****  calculate eigenvalues  *****
  % step size
  h = 1e-7; 
  
  % linearized A
  x0 = [init_x;init_w]; 

  tmpA = zeros(length(x0)); 
  flag = 1*ones(1,NW);
  flag_pv = 1*ones(1,NP); 
  ff = 0; 
  n_ode = n + n_dae(flag, flag_pv); 
  for k=1:length(x0)
    e = h*EYE(length(x0), k); 
    tmpA(:,k) = (psm_15s(0, x0+e) - psm_15s(0, x0))/h; 
  end
  
  %partion of A
  A11 = tmpA(1:net.n, 1:net.n); 
  A12 = tmpA(1:net.n, net.n+1:net.n+net.nDAE); 
  A13 = tmpA(1:net.n, net.n+net.nDAE+1:end);
  A21 = tmpA(net.n+1:net.n+net.nDAE, 1:net.n); 
  A22 = tmpA(net.n+1:net.n+net.nDAE, net.n+1:net.n+net.nDAE); 
  A23 = tmpA(net.n+1:net.n+net.nDAE, net.n+net.nDAE+1:end);
  A31 = tmpA(net.n+net.nDAE+1:end, 1:net.n); 
  A32 = tmpA(net.n+net.nDAE+1:end, net.n+1:net.n+net.nDAE); 
  A33 = tmpA(net.n+net.nDAE+1:end, net.n+net.nDAE+1:end);
  
  %kron-reduction
  wholew.A = [A11,A13;A31,A33] - [A12;A32]*inv(A22)*[A21,A23];

  %eigenvalues
  [wholew.vec, E] = eig(wholew.A); wholew.E = diag(E); 
  
end
