%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define solar farm parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%1-Rated power [MVA]
%2-Rated voltage 
%3-LG (H)  
%4-RG (ohm)   
%5-Gdc (ohm^-1)
%6-Cdc (uF)
%7-ipv_s (A)  not used
%8-Rpv (ohm)
%9-Vpv (V)
%10-Vdc' (V)
pv_con = [ 
  2 690 0.002 0.000238 1e-6 1e4  7616.2  0.0366  568.128  289.3;
  ];

%% penetration of solar (connected bus#, reactance, P[MW])
if norm(gamma_pv) > 0
  %mpc.PVdata = [[22; 0.01; gamma_pv(1)*pv_con(1,1)]]; 
  mpc.PVdata = [[66; 0.01; gamma_pv(1)*pv_con(1,1)]]; 
else
  mpc.PVdata = [];
end

% 1-tauG
% 2-Kp_dG
% 3-Ki_dG 
% 4-Kp_qG
% 5-Ki_qG 
% 6-duty saturation 
pvp = [  
  0.7  -0.01  -0.1  0.01  0.1  1e0;
  ];

if(pv_con(5) == 0); error('Gdc should be nonzero'); end