%
% Bus, Branch, machine data are cited from "Robust Control in Power Systems" by Pai, Stankovic
% Add a branch 18-50 to the above. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% simulation settings
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sims.te = 200;%final time 
sims.ft = 0.07;%fault time (used for fault simulation)

sims.odemem = 0; %memory to show ode progress(must be 0)
sims.odeprg = 30;%positive: display ode progress, -1:none
sims.odeprgx= 1; %1:display norm(x) when you display ode progress

tol = 1e-8; % DAE calculation quality

% input by retrofit controller   1: storage, 2 wind+storage
retc = [1]; 

%local controller type   1: state feedback   2:output feedback
lc_type = [1];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Power Flow Data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mpc.version = '2';

%% system MVA base
mpc.baseMVA = 100;

mpc.baseV = 690; %must be 690 (Note; does not affect on syncgen dynamics)

%% Load type:  1-constant power  2-constant impedance
mpc.load = 2;

%% bus data
% col1 number
% col2 voltage magnitude(pu)
% col3 voltage angle(degree)
% col4 p_gen(pu)
% col5 q_gen(pu),
% col6 p_load(pu)
% col7 q_load(pu)
% col8 G shunt(pu)
% col9 B shunt(pu)
% col10 bus_type
%       bus_type - 1, swing bus
%               - 2, generator bus (PV bus)
%               - 3, load bus (PQ bus)
%               - 4, solar bus (PQ bus)
% col11 q_gen_max(pu)
% col12 q_gen_min(pu)
% col13 v_rated (kV)
% col14 v_max  pu
% col15 v_min  pu
mpc.bus = [
 01 1.045 0.00 2.50 0.00 0.00 0.00 0.00 0.00 2 0.825 -0.825;
 02 0.98 0.00 5.45 0.00 0.00 0.00 0.00 0.00 2 1.7985 -1.7985;
 03 0.983 0.00 6.50 0.00 0.00 0.00 0.00 0.00 2 2.145 -2.145;
 04 0.997 0.00 6.32 0.00 0.00 0.00 0.00 0.00 2 2.0856 -2.0856;
 05 1.011 0.00 5.05 0.00 0.00 0.00 0.00 0.00 2 1.6665 -1.6665;
 06 1.050 0.00 7.00 0.00 0.00 0.00 0.00 0.00 2 2.31 -2.31;
 07 1.063 0.00 5.60 0.00 0.00 0.00 0.00 0.00 2 1.848 -1.848;
 08 1.03 0.00 5.40 0.00 0.00 0.00 0.00 0.00 2 2.782 -1.782;
 09 1.025 0.00 8.00 0.00 0.00 0.00 0.00 0.00 2 2.64 -2.64;
 10 1.010 0.00 5.00 0.00 0.00 0.00 0.00 0.00 2 1.65 -1.65;
 11 1.000 0.00 10.000 0.00 0.00 0.00 0.00 0.00 2 3.3 -3.3;
 12 1.0156 0.00 13.50 0.00 0.00 0.00 0.00 0.00 2 4.455 -4.455;
 13 1.011 0.00 35.91 0.00 0.00 0.00 0.00 0.00 2 11.85 -11.85;
 14 1.00 0.00 17.85 0.00 0.00 0.00 0.00 0.00 2 5.89 -5.89;
 15 1.000 0.00 10.00 0.00 0.00 0.00 0.00 0.00 2 3.3 -3.3; 
 16 1.000 0.00 40.00 0.00 0.00 0.00 0.00 0.00 1 13.2 -13.2;
 17 1.00 0.00 0.00 0.00 60.00 3.00 0.00 0.00 3 0 0;
 18 1.00 0.00 0.00 0.00 24.70 1.23 0.00 0.00 3 0 0;
 19 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 20 1.00 0.00 0.00 0.00 6.800 1.03 0.00 0.00 3 0 0;
 21 1.00 0.00 0.00 0.00 2.740 1.15 0.00 0.00 3 0 0;
 22 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 23 1.00 0.00 0.00 0.00 2.480 0.85 0.00 0.00 3 0 0;
 24 1.00 0.00 0.00 0.00 3.09 -0.92 0.00 0.00 3 0 0;
 25 1.00 0.00 0.00 0.00 2.24 0.47 0.00 0.00 3 0 0;
 26 1.00 0.00 0.00 0.00 1.39 0.17 0.00 0.00 3 0 0;
 27 1.00 0.00 0.00 0.00 2.810 0.76 0.00 0.00 3 0 0;
 28 1.00 0.00 0.00 0.00 2.060 0.28 0.00 0.00 3 0 0;
 29 1.00 0.00 0.00 0.00 2.840 0.27 0.00 0.00 3 0 0;
 30 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 31 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 32 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 33 1.00 0.00 0.00 0.00 1.12 0.00 0.00 0.00 3 0 0;
 34 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 35 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 36 1.00 0.00 0.00 0.00 1.02 -0.1946 0.00 0.00 3 0 0;
 37 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 38 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 39 1.00 0.00 0.00 0.00 2.67 0.126 0.00 0.00 3 0 0;
 40 1.00 0.00 0.00 0.00 0.6563 0.2353 0.00 0.00 3 0 0;
 41 1.00 0.00 0.00 0.00 10.00 2.50 0.00 0.00 3 0 0;
 42 1.00 0.00 0.00 0.00 11.50 2.50 0.00 0.00 3 0 0;
 43 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 44 1.00 0.00 0.00 0.00 2.6755 0.0484 0.00 0.00 3 0 0;
 45 1.00 0.00 0.00 0.00 2.08 0.21 0.00 0.00 3 0 0;
 46 1.00 0.00 0.00 0.00 1.507 0.285 0.00 0.00 3 0 0;
 47 1.00 0.00 0.00 0.00 2.0312 0.3259 0.00 0.00 3 0 0;
 48 1.00 0.00 0.00 0.00 2.4120 0.022 0.00 0.00 3 0 0;
 49 1.00 0.00 0.00 0.00 1.6400 0.29 0.00 0.00 3 0 0;
 50 1.00 0.00 0.00 0.00 1.00 -1.47 0.00 0.00 3 0 0;
 51 1.00 0.00 0.00 0.00 3.37 -1.22 0.00 0.00 3 0 0;
 52 1.00 0.00 0.00 0.00 1.58 0.30 0.00 0.00 3 0 0;
 53 1.00 0.00 0.00 0.00 2.527 1.1856 0.00 0.00 3 0 0;
 54 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 55 1.00 0.00 0.00 0.00 3.22 0.02 0.00 0.00 3 0 0;
 56 1.00 0.00 0.00 0.00 2.00 0.736 0.00 0.00 3 0 0;
 57 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 58 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 59 1.00 0.00 0.00 0.00 2.34 0.84 0.00 0.00 3 0 0;
 60 1.00 0.00 0.00 0.00 2.088 0.708 0.00 0.00 3 0 0;
 61 1.00 0.00 0.00 0.00 1.04 1.25 0.00 0.00 3 0 0;
 62 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 63 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 64 1.00 0.00 0.00 0.00 0.09 0.88 0.00 0.00 3 0 0;
 65 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 66 1.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 3 0 0;
 67 1.00 0.00 0.00 0.00 3.200 1.5300 0.00 0.00 3 0 0;
 68 1.00 0.00 0.00 0.00 3.290 0.32 0.00 0.00 3 0 0];

%% branch data
% fbus	tbus	r	x	b	tap	tap phase
mpc.branch = [
 01 54 0 0.0181 0 1.0250 0;
 02 58 0 0.0250 0 1.0700 0;
 03 62 0 0.0200 0 1.0700 0;
 04 19 0.0007 0.0142 0 1.0700 0;
 05 20 0.0009 0.0180 0 1.0090 0;
 06 22 0 0.0143 0 1.0250 0;
 07 23 0.0005 0.0272 0 0 0;
 08 25 0.0006 0.0232 0 1.0250 0;
 09 29 0.0008 0.0156 0 1.0250 0;
 10 31 0 0.0260 0 1.0400 0;
 11 32 0 0.0130 0 1.0400 0;
 12 36 0 0.0075 0 1.0400 0;
 13 17 0 0.0033 0 1.0400 0;
 14 41 0 0.0015 0 1.0000 0;
 15 42 0 0.0015 0 1.0000 0;
 16 18 0 0.0030 0 1.0000 0;
 17 36 0.0005 0.0045 0.3200 0 0;
 18 49 0.0076 0.1141 1.1600 0 0;
 18 50 0.0012 0.0288 2.0600 0 0;
 19 68 0.0016 0.0195 0.3040 0 0;
 20 19 0.0007 0.0138 0 1.0600 0;
 21 68 0.0008 0.0135 0.2548 0 0;
 22 21 0.0008 0.0140 0.2565 0 0;
 23 22 0.0006 0.0096 0.1846 0 0;
 24 23 0.0022 0.0350 0.3610 0 0;
 24 68 0.0003 0.0059 0.0680 0 0;
 25 54 0.0070 0.0086 0.1460 0 0;
 26 25 0.0032 0.0323 0.5310 0 0;
 27 37 0.0013 0.0173 0.3216 0 0;
 27 26 0.0014 0.0147 0.2396 0 0;
 28 26 0.0043 0.0474 0.7802 0 0;
 29 26 0.0057 0.0625 1.0290 0 0;
 29 28 0.0014 0.0151 0.2490 0 0;
 30 53 0.0008 0.0074 0.4800 0 0;
 30 61 0.00095 0.00915 0.5800 0 0;
 31 30 0.0013 0.0187 0.3330 0 0;
 31 53 0.0016 0.0163 0.2500 0 0;
 32 30 0.0024 0.0288 0.4880 0 0;
 33 32 0.0008 0.0099 0.1680 0 0;
 34 33 0.0011 0.0157 0.2020 0 0;
 34 35 0.0001 0.0074 0 0.9460 0;
 36 34 0.0033 0.0111 1.4500 0 0;
 36 61 0.0011 0.0098 0.6800 0 0;
 37 68 0.0007 0.0089 0.1342 0 0;
 38 31 0.0011 0.0147 0.2470 0 0;
 38 33 0.0036 0.0444 0.6930 0 0;
 40 41 0.0060 0.0840 3.1500 0 0;
 40 48 0.0020 0.0220 1.2800 0 0;
 41 42 0.0040 0.0600 2.2500 0 0;
 42 18 0.0040 0.0600 2.2500 0 0;
 43 17 0.0005 0.0276 0 0 0;
 44 39 0 0.0411 0 0 0;
 44 43 0.0001 0.0011 0 0 0;
 45 35 0.0007 0.0175 1.3900 0 0;
 45 39 0 0.0839 0 0 0;
 45 44 0.0025 0.0730 0 0 0;
 46 38 0.0022 0.0284 0.4300 0 0;
 47 53 0.0013 0.0188 1.3100 0 0;
 48 47 0.00125 0.0134 0.8000 0 0;
 49 46 0.0018 0.0274 0.2700 0 0;
 51 45 0.0004 0.0105 0.7200 0 0;
 51 50 0.0009 0.0221 1.6200 0 0;
 52 37 0.0007 0.0082 0.1319 0 0;
 52 55 0.0011 0.0133 0.2138 0 0;
 54 53 0.0035 0.0411 0.6987 0 0;
 55 54 0.0013 0.0151 0.2572 0 0;
 56 55 0.0013 0.0213 0.2214 0 0;
 57 56 0.0008 0.0128 0.1342 0 0;
 58 57 0.0002 0.0026 0.0434 0 0;
 59 58 0.0006 0.0092 0.1130 0 0;
 60 57 0.0008 0.0112 0.1476 0 0;
 60 59 0.0004 0.0046 0.0780 0 0;
 61 60 0.0023 0.0363 0.3804 0 0;
 63 58 0.0007 0.0082 0.1389 0 0;
 63 62 0.0004 0.0043 0.0729 0 0;
 63 64 0.0016 0.0435 0 1.0600 0;
 65 62 0.0004 0.0043 0.0729 0 0;
 65 64 0.0016 0.0435 0 1.0600 0;
 66 56 0.0008 0.0129 0.1382 0 0;
 66 65 0.0009 0.0101 0.1723 0 0;
 67 66 0.0018 0.0217 0.3660 0 0;
 68 67 0.0009 0.0094 0.1710 0 0;
 27 53 0.0320 0.3200 0.4100 1.0000 0;
 ];

% **** Change bus & branch information to that connecting to wind plant ****
index = size(mpc.bus,1); 
mpc.added_wind = []; 
for lp=1:length(gamma)
  if gamma(lp)>0
    % add bus information
    mpc.bus = [mpc.bus; 
      index+1 1.00 0.00 gamma(lp)*(wind_con(lp,19)/mpc.baseMVA) 0.00 0.00 0.00 0.00 0.00 2 999 -999];
    
    mpc.added_wind = [mpc.added_wind, index+1]; 
    % add branch information
    mpc.branch = [mpc.branch;
      wind_con(lp,2) index+1 0 wind_con(lp,26) 0 1.00 0];
  
    index = index+1; 
  end
end

% **** Change bus information to that connecting to wind plant ****
index = size(mpc.bus,1); 
mpc.added_PV = []; 
for lp=1:size(mpc.PVdata, 2)
  % add bus information
  mpc.bus = [mpc.bus;
    index+1 1.00 0.00 mpc.PVdata(3,lp)/mpc.baseMVA 0 0 0.00 0.00 0.00 4 999 -999];
  
  mpc.added_PV = [mpc.added_PV, index+1];  
  % add branch information
  mpc.branch = [mpc.branch;
    mpc.PVdata(1,lp) index+1 0 mpc.PVdata(2,lp) 0 1.00 0];
  
  index = index + 1;
 end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Machine data format
%       1. machine number,
%       2. bus number,
%       3. base mva,
%       4. leakage reactance x_l(pu),
%       5. resistance r_a(pu),
%       6. d-axis sychronous reactance x_d(pu),
%       7. d-axis transient reactance x'_d(pu),
%       8. d-axis subtransient reactance x"_d(pu),
%       9. d-axis open-circuit time constant T'_do(sec),
%      10. d-axis open-circuit subtransient time constant T"_do(sec),
%      11. q-axis sychronous reactance x_q(pu),
%      12. q-axis transient reactance x'_q(pu),
%      13. q-axis subtransient reactance x"_q(pu),
%      14. q-axis open-circuit time constant T'_qo(sec),
%      15. q-axis open circuit subtransient time constant T"_qo(sec),
%      16. inertia constant H(sec),
%      17. damping coefficient d_o(pu),
%      18. dampling coefficient d_1(pu),
%
%   remark; data is based on self capacity. Thus, Xd etc must be modified
%   however, Tdo etc are not be modified because we need Tdo, but not Td.
%   ra must be zero. if not, change formula of output power of sync.gen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mac_con = [
 01 01 100 0.0125 0.0 0.1 0.031 0.025 10.2 0.05 0.069 0.028 0.025 1.5 0.035 42.0 4.0 0 01 0 0;
 02 02 100 0.035 0.0 0.295 0.0697 0.05 6.56 0.05 0.282 0.060 0.05 1.5 0.035 30.2 9.75 0 02 0 0;
 03 03 100 0.0304 0.0 0.2495 0.0531 0.045 5.7 0.05 0.237 0.050 0.045 1.5 0.035 35.8 10 0 03 0 0;
 04 04 100 0.0295 0.0 0.262 0.0436 0.035 5.69 0.05 0.258 0.040 0.035 1.5 0.035 28.6 10 0 04 0 0;
 05 05 100 0.027 0.0 0.33 0.066 0.05 5.4 0.05 0.31 0.060 0.05 0.44 0.035 26.0 3 0 05 0 0;
 06 06 100 0.0224 0.0 0.254 0.05 0.04 7.3 0.05 0.241 0.045 0.04 0.4 0.035 34.8 10 0 06 0 0;
 07 07 100 0.0322 0.0 0.295 0.049 0.04 5.66 0.05 0.292 0.045 0.04 1.5 0.035 26.4 8 0 07 0 0;
 08 08 100 0.028 0.0 0.29 0.057 0.045 6.7 0.05 0.280 0.05 0.045 0.41 0.035 24.3 9 0 08 0 0;
 09 09 100 0.0298 0.0 0.2106 0.057 0.045 4.79 0.05 0.205 0.05 0.045 1.96 0.035 34.5 14 0 09 0 0;
 10 10 100 0.0199 0.0 0.169 0.0457 0.04 9.37 0.05 0.115 0.045 0.04 1.5 0.035 31.0 5.56 0 10 0 0;
 11 11 100 0.0103 0.0 0.128 0.018 0.012 4.1 0.05 0.123 0.015 0.012 1.5 0.035 28.2 13.6 0 11 0 0;
 12 12 100 0.022 0.0 0.101 0.031 0.025 7.4 0.05 0.095 0.028 0.025 1.5 0.035 92.3 13.5 0 12 0 0;
 13 13 200 0.0030 0.0 0.0296 0.0055 0.004 5.9 0.05 0.0286 0.005 0.004 1.5 0.035 248.0 33 0 13 0 0;
 14 14 100 0.0017 0.0 0.018 0.00285 0.0023 4.1 0.05 0.0173 0.0025 0.0023 1.5 0.035 600.0 100 0 14 0 0;
 15 15 100 0.0017 0.0 0.018 0.00285 0.0023 4.1 0.05 0.0173 0.0025 0.0023 1.5 0.035 600.0 100 0 15 0 0;
 16 16 200 0.0041 0.0 0.0356 0.0071 0.0055 7.8 0.05 0.0334 0.006 0.0055 1.5 0.035 225.0 50 0 16 0 0];

% slightly modify the parameters such that the inter-area oscillation mode appears in a typical frequency range [0.1, 2] Hz 
mac_con(:,16) = 3*mac_con(:,16); 
mac_con(:,9) = 1.5*mac_con(:,9); 

exc_con = [
0 1 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
0 2 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
0 3 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
0 4 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
0 5 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 6 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 7 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 8 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 9 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 10 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 11 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 12 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 13 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 14 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 15 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0;
 0 16 0.01 200.0  0.05     0     0    5.0  -5.0    0    0      0     0     0    0    0      0      0    0   0];

pss_con = [
     1  1  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  2  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  3  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  4  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  5  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  6  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  7  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  8  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  9  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  10  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  11  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  12  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  13  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  14  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  15  150  10 0.07 0.02 0.07 0.02 0.2 -0.05;
     1  16  150  10 0.07 0.02 0.07 0.02 0.2 -0.05];

% modify mac_con to that based on system capacity
mac_con(:,4) = mac_con(:,4) ./ (mac_con(:,3)/mpc.baseMVA); %xl
mac_con(:,5) = mac_con(:,5) ./ (mac_con(:,3)/mpc.baseMVA); %ra
mac_con(:,7) = mac_con(:,7) ./ (mac_con(:,3)/mpc.baseMVA); %x'd
mac_con(:,8) = mac_con(:,8) ./ (mac_con(:,3)/mpc.baseMVA); %x''d
mac_con(:,11) = mac_con(:,11) ./ (mac_con(:,3)/mpc.baseMVA); %xq
mac_con(:,12) = mac_con(:,12) ./ (mac_con(:,3)/mpc.baseMVA); %x'q
mac_con(:,13) = mac_con(:,13) ./ (mac_con(:,3)/mpc.baseMVA); %x''q
mac_con(:,16) = 2*mac_con(:,16) .* (mac_con(:,3)/mpc.baseMVA); %M
mac_con(:,17) = mac_con(:,17) .* (mac_con(:,3)/mpc.baseMVA); %D
  
% define areas
area{1} = [1:9];
area{2} = [10:13];
area{3} = [14];
area{4} = [15];
area{5} = [16];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if(length(gamma) > length(retc))
  error('length of retc is less than # of wind');
elseif(length(gamma) > length(lc_type))
  error('length of retc is less than # of wind');  
end
if(size(wind_con, 1) ~= length(gamma))
  error('size of windcon differs from # of wind');
end
if(~isempty(find(gamma == 0)) & norm(gamma)>0)
  error('every entry of gamma must be nonzero');
end
if(sims.fbus > size(mpc.bus, 1))
  error('Fault bus should be one of existing buses');
end