% ***********************************
% Calculate states of syncgens
%
% Angle difference w.r.t. base syncgen[deg]
% Frequency difference [Hz]
% Active power [MW]
% Rective power [MW]
% Bus voltage magnitude [pu]
% Bus voltage angle [deg]
% ***********************************
del = 180/pi*x(:,out.del);
ome = (1/(2*pi))*omega0*x(:,out.ome);
thdiff = zeros(size(x,1), NG-1); 
for j=1:NG
  thdiff(:,j) = del(:,j) - del(:,net.bG);
end

% bus voltage in dq
E = x(:, [net.EGi, net.ELi, net.EWi, net.EPi]); 
EG = E(:, net.EGi-net.n); 
EL = E(:, net.ELi-net.n); 
EW = E(:, net.EWi-net.n); 
EP = E(:, net.EPi-net.n); 
  
% syncgen power in dq
P = zeros(length(t),net.nDAE); 
I = (Yk*E')'; 
Ic = I(:,[1:2:end]) + sqrt(-1)*I(:,[2:2:end]);
Ec = E(:,[1:2:end]) + sqrt(-1)*E(:,[2:2:end]);
Pc = conj(Ic) .* Ec; 

PG = Pc(:, net.EGi_c-net.n); 
PL = Pc(:, net.ELi_c-net.n); 
PW = Pc(:, net.EWi_c-net.n); 
PP = Pc(:, net.EPi_c-net.n); 

% syncgen bus voltage magnitude (pu) & angle (rad)
[vabs_G, vang_G] = sig_polar(EG); 
[vabs_L, vang_L] = sig_polar(EL); 
[vabs_W, vang_W] = sig_polar(EW); 
[vabs_P, vang_P] = sig_polar(EP); 

% syncgen PSS input
uPSS = zeros(length(t),NG); 
for k=1:length(t)
  if(flag_g == 1); uG = gl.F*x(k, gl.si)'; else; uG = zeros(NG,1); end
  for j=1:NG
    uPSS(k,j) = dae{j}.pssU(x(k,gpar{j}.si)', uG(j)); 
  end
end