%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function is used to add trajectories before fault occurs. 
% This is not essential for all simulations, but useful to emphasize when fault happens. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [t_ret, x_ret] = add_prefault_traj(t,x,t_h,x0)
global sims net

tmp = linspace(t_h, t(1), round((t(1)-t_h)/0.01))'; 
xtmp = ones(length(tmp),1)*x0'; 

t_ret = [tmp(1:end-1); t]; 
x_ret = [xtmp(1:end-1,:);x]; 
