clear all;
close all;

Ipv = 8.214;
I0 = 9.825*1e-8;
Rs = 0.221;
Rp = 415.405;
a = 1.3;
Vt = 54*1.38064852*1e-23*(25+273)/(1.6*1e-19);

f = @(V,I) -I+Ipv-I0*(exp((V+Rs*I)/(Vt*a)) - 1)-(V+Rs*I)/Rp;

Vs = 0:0.5:34;
Is = zeros(1, length(Vs));
for lp=1:length(Vs)
  V = Vs(lp);
  [ii,fval,flag,output,jacob] = fsolve(@(I) f(V,I), 8);
  Is(lp) = ii;
end
figure; plot(Vs, Is); ylim([0 9]); grid on; %xlim([0 34]); 
%figure; plot(Vs, Is.*Vs, 'r-'); xlim([0 34]); grid on;

% find PV array parameters

r = 1000
c = 11;
Vmp = 26.3;
Req = 3.3309;
Veq = 51.6480;
[Imp,fval,flag,output,jacob] = fsolve(@(I) f(Vmp,I), 8);

IPV = Imp*r
VPV = Vmp*c
REQ = (Req*c)/r
VEQ = Veq*c

PPV = VPV*IPV/1e6; %output power (MW)

figure(1)
Vs = 20:0.5:55;
hold on; plot(Vs, Veq/Req-(1/Req)*Vs, 'r-');

IPV_ = IPV/(2*1e6/690); 
VPV_ = VPV/690;
VEQ_ = VEQ/690;
REQ_ = REQ/(690/(2*1e6/690)); 

if 1
  
end